(function($) {
    $(function() {
        var jcarousel = $('.promotion-jcarousel');

        jcarousel
            .on('jcarousel:reload jcarousel:create', function () {
                var carousel = $(this),
                    width = carousel.innerWidth();
                if (width >= 576) {
                    width = width /2;
                }

                carousel.jcarousel('items').css('width', Math.ceil(width) + 'px');
            })
            .jcarousel({
                wrap: 'circular',
                pagination:true
            });

        $('.promotion-jcarousel-control-prev')
            .jcarouselControl({
                target: '-=1'
            });

        $('.promotion-jcarousel-control-next')
            .jcarouselControl({
                target: '+=1'
            });
        $('.promotion-jcarousel-control-prev').on('click', function(e) {
                $('.promotion-jcarousel').jcarousel('scroll', "-=1");
         });
        $('.promotion-jcarousel-control-next').on('click', function(e) {
                $('.promotion-jcarousel').jcarousel('scroll',  "+=1");
         });
        $('.jcarousel-pagination')
            .on('jcarouselpagination:active', 'a', function() {
                $(this).addClass('active');
            })
            .on('jcarouselpagination:inactive', 'a', function() {
                $(this).removeClass('active');
            })
            .on('click', function(e) {
                e.preventDefault();
            })
            .jcarouselPagination({
                perPage: 1,
                item: function(page) {
                    return '<a href="#' + page + '">' + page + '</a>';
                }
            });
    });
})(jQuery);
