(function($) {
    $(function() {
        var jcarousel = $('.ajcarousel');
        var paging = 3;
        jcarousel
            .on('jcarousel:reload jcarousel:create', function () {
                var carousel = $(this),
                    width = carousel.innerWidth();

                if (width >= 604) {
                    width = width / 2;
                    paging  = 2;
                }else{
                    width = width / 1;
                    paging  = 1;
                }

                carousel.jcarousel('items').css('width', Math.ceil(width) + 'px');
            })
            .jcarousel({
                wrap: 'both'
            })
            .jcarouselSwipe({
                perSwipe:1
            });
        $('.ajcarousel-control-prev')
            .jcarouselControl({
                target: '-=1'
            });

        $('.ajcarousel-control-next')
            .jcarouselControl({
                target: '+=1'
            });

        $('.ajcarousel-pagination')
            .on('jcarouselpagination:active', 'a', function() {
                $(this).addClass('active');
            })
            .on('jcarouselpagination:inactive', 'a', function() {
                $(this).removeClass('active');
            })
            .on('click', function(e) {
                e.preventDefault();
            })
            .jcarouselPagination({
                perPage: paging,
                item: function(page) {
                    return '<a href="#' + page + '">' + page + '</a>';
                }
            });
    });
})(jQuery);
