<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!DOCTYPE html>
<head>
	<link rel="shortcut icon"  type="image/x-icon" href="<?php echo base_url('assets/image/logo.png');?>">
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title><?php if(isset($page_title)){echo $page_title;}?></title>
	<meta name="description" content="<?php echo $meta_desc;?>">
  <meta name="keywords" content="<?php echo $meta_keyword;?>">
  <meta name="author" content="LUXA">

<?php if(isset($meta_og_url)){?>
  <meta property="og:url" content="<?php echo $meta_og_url;?>" />
<?php }?>
<?php if(isset($meta_og_title)){?>
  <meta property="og:title" content="<?php echo $meta_og_title;?>" />
<?php }?>
<?php if(isset($meta_og_desc)){?>
  <meta property="og:description" content="<?php echo $meta_og_desc;?>" />
<?php }?>
<?php if(isset($meta_og_image)){?>
  <meta property="og:image" content="<?php echo $meta_og_image;?>" />
<?php }?>

  <link rel="icon" type="image/png" href="<?php echo base_url('assets/image/favicon_v2.png');?>">
  <link rel="stylesheet" href="<?php echo base_url('assets/fonts/fonts.css'); ?>">
  <link rel="stylesheet" href="<?php echo base_url('assets/fonts/kanit/fonts.css'); ?>">
  <?php echo css_asset('fonts.css'); ?>

  <?php echo css_asset('open-iconic.css'); ?>
	<?php echo js_asset('jquery-1.12.0.js'); ?>
  <?php echo js_asset('popper.js'); ?>
	<?php echo js_asset('bootstrap.min.js'); ?>
	<?php echo css_asset('bootstrap.min.css'); ?>
	<?php echo css_asset('font-awesome.css'); ?>
	<?php echo js_asset('jquery.bxslider.js'); ?>
	<?php echo js_asset('vendor/jquery.easing.1.3.js'); ?>
	<?php echo css_asset('jquery.bxslider.css?v=7'); ?>
	<?php echo css_asset('animate.css'); ?>
	<?php echo css_asset('irin.css'); ?>
  <?php echo css_asset('responesive.css'); ?>
  <?php echo css_asset('irin-resp.css'); ?>  
  <!-- Global site tag (gtag.js) - Google Analytics -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=UA-121800756-1"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'UA-121800756-1');
  </script>
  
  <!-- Facebook Pixel Code -->
  <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '680523752120272');
    fbq('track', 'PageView');
  </script>
  <noscript><img height="1" width="1" style="display:none"
  src="https://www.facebook.com/tr?id=680523752120272&ev=PageView&noscript=1"
  /></noscript>
  <!-- End Facebook Pixel Code -->
  <!-- Google Tag Manager -->
  <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
  new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
  j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
  'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
  })(window,document,'script','dataLayer','GTM-P58DCDT');</script>
  <!-- End Google Tag Manager -->
</head>
<body>
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-P58DCDT"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<!-- Global site tag (gtag.js) - Google Ads: 867757836 -->
<script async src="https://www.googletagmanager.com/gtag/js?id=AW-867757836"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-867757836');
</script>
<nav class="navbar navbar-expand-lg irin-head">
  <a class="navbar-brand" href="<?php echo base_url('Home'); ?>">
  	<img src="<?php echo base_url('assets/image/logo_irin.png');?>" alt="">
  </a>
  <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
    <div class="navbar-toggler-icon"></div>
    <div class="navbar-toggler-icon"></div>
    <div class="navbar-toggler-icon"></div>
  </button>
  <div class="collapse navbar-collapse main-menu" id="navbarSupportedContent">
    <ul class="navbar-nav m-auto float-right">
      <li class="nav-item p_active">                 
        <a class="nav-link" href="<?php echo base_url('Product'); ?>"><?php echo $txt_product; ?></a>
      </li>
      <li class="nav-item a_active">
        <a class="nav-link" href="<?php echo base_url('Article'); ?>"><?php echo $txt_article; ?></a>
      </li>
      <li class="nav-item w_active">
      	<a class="nav-link" href="<?php echo base_url('Wheretobuy'); ?>"><?php echo $txt_where_to_buy; ?></a>
      </li>
      <li class="nav-item pr_active">
        <a class="nav-link" href="<?php echo base_url('Promotion'); ?>"><?php echo $txt_promotion; ?></a>
      </li>
      <li class="nav-item r_active">
        <a class="nav-link" href="<?php echo base_url('Review'); ?>"><?php echo $txt_review; ?></a>
      </li>
      <li class="nav-item ab_active">
        <a class="nav-link" href="<?php echo base_url('About'); ?>"><?php echo $txt_about; ?></a>
      </li>
      <li class="nav-item c_active">
        <a class="nav-link" href="<?php echo base_url('Contact'); ?>"><?php echo $txt_contact; ?></a>
      </li>
    </ul>
    <div class="form-inline my-2 my-lg-0 h-icon">
		<div class="mr-sm-2 signupnav">
      <?php
        if(!$this->session->userdata('cus_logged_in')){
      ?>
        <img src="<?php echo base_url('assets/image/icon/user_profile.png');?>" alt="" id="user_signup" class="m-d-none">
        <span class="arrow m-d-none"></span>
        <span class="logon-regis m-d-none">
          <a href="#" data-toggle="modal" data-target="#loginmodal" id="menu-login"><?php echo $txt_login; ?></a> <a><span class="slash">/</span></a> 
          <a href="#" data-toggle="modal" data-target="#registermodal" id="menu-register"><?php echo $txt_sign; ?></a></a>
        </span>
        <div class="dropdown logon-regis des-none">
          <button class="btn btn-link dropdown-toggle account" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <img src="<?php echo base_url('assets/image/icon/user_profile.png');?>" alt="" id="user_signup">
          </button>
          <div class="dropdown-menu">
            <div class="arrow"></div>
            <a href="#" data-toggle="modal" data-target="#loginmodal" class="dropdown-item" id="menu-login"><?php echo $txt_login; ?></a> 
            <span class="slash">/</span>
            <a href="#" data-toggle="modal" data-target="#registermodal" class="dropdown-item" id="menu-register"><?php echo $txt_sign; ?></a>
          </div>
        </div>
      <?php 
      }else{
          $session_account = $this->session->userdata('cus_logged_in');
      ?>
         <div class="dropdown">
          <button class="btn btn-link dropdown-toggle account" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <img src="<?php echo base_url('assets/image/icon/user_profile.png');?>" alt="">
           <span  class="desktop"><?php echo $session_account['name'];?></span>
          </button>
          <div class="dropdown-menu">
            <div class="arrow"></div>
              <div class="dropdown-item des-none" style="text-transform: uppercase;"></span> <?php echo $session_account['name'];?></div>
              <a class="dropdown-item" href="<?php echo base_url('Profile'); ?>"><span class="oi" data-glyph="person"></span> <?php echo $txt_edit; ?></a>
              <a class="dropdown-item" href="<?php echo base_url('Profile')."/editPassword"; ?>"><span class="oi" data-glyph="key"></span> <?php echo $txt_change; ?></a>
              <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutmodal"><span class="oi" data-glyph="power-standby"></span> <?php echo $txt_logout; ?></a>
          </div>
        </div>
      <?php
      }
      ?>
		</div>
		<div class="mr-sm-2 h-cart">
      <div class="dropdown">
        <button class="btn btn-link dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          <img src="<?php echo base_url('assets/image/icon/cart.png');?>" alt="">
          <span class="badge badge-danger badge-cart"></span>
        </button>
        <div class="dropdown-menu mycart">
          <div class="arrow"></div>
          <p class="empty"><?php echo $txt_cartemp; ?></p>
        </div>
      </div>
    </div>
		<div class="mr-sm-2">
      <!--div class="dropdown">
        <button class="btn btn-link dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          <img src="<?php echo base_url('assets/image/icon/lang.png');?>" alt="">
        </button>
        <div class="dropdown-menu">
          <div class="arrow"></div>
          <div class="dropdown-item lang" data-code="TH">
            <img src="<?php echo base_url('assets/image/icon/flag_th.png');?>" alt="" width="27"> TH
          </div>
          <div class="dropdown-item lang" data-code="EN">
            <img src="<?php echo base_url('assets/image/icon/flag_en.png');?>" alt="" width="27"> EN
          </div>
        </div>
      </div-->
      <div class="text-lang">
        <div class=" des-none lang" data-code="<?php echo ($this->session->userdata('lang')=="TH")?"EN":"TH"; ?>" style="padding-right:16px; padding-top: 1px; padding-left: 10px">
          <?php if($this->session->userdata('lang')=="TH"){?>
           <img src="<?php echo base_url('assets/image/icon/flag_en.png');?>" alt="" width="27">
          <?php }else{?>
            <img src="<?php echo base_url('assets/image/icon/flag_th.png');?>" alt="" width="27">
          <?php
          }
          ?>
        </div>
        <div class=" m-d-none lang <?php echo ($this->session->userdata('lang')=="TH")?"color-blue":""; ?>" data-code="TH">
          <span>TH</span>
        </div>
        <div class="langslash m-d-none"><span>|</span></div>
        <div class=" m-d-none lang <?php echo ($this->session->userdata('lang')=="EN")?"color-blue":""; ?>"" data-code="EN">
          <span>EN</span>
        </div>
      </div>
		</div>
    </div>
  </div>
</nav>
<!-- SIGNUP Modal -->
<div class="modal fade irinmodal" id="registermodal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <div class="row">
          <div class="col-md-6 text-center">
            <h5 class="modal-title"><span><?php echo $txt_sign; ?></span></h5>
          </div>
        </div>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <div class="error-message register-error-message"></div>
          </div>
          <div class="col-md-7">
              <div class="form-group">
                <input type="text" class="form-control" name="txt_name" id="txt_name" placeholder="<?php echo $txt_name; ?>" required>
              </div>
              <div class="form-group">
                <input type="email" class="form-control" name="txt_email" id="txt_email" placeholder="<?php echo $txt_mail; ?>" required>
              </div>
              <div class="form-group">
                <input type="password" class="form-control" name="txt_pass" id="txt_pass" placeholder="<?php echo $txt_pass ?>" required>
              </div>
              <div class="form-group">
                <input type="password" class="form-control" name="txt_repass" id="txt_repass" placeholder="<?php echo $txt_conpass; ?>" required>
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="txt_tel" id="txt_tel" placeholder="<?php echo $txt_phone; ?>" required>
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="txt_line" id="txt_line" placeholder="<?php echo $txt_line; ?>" required>
              </div>              
              <div class="form-group">
                <input type="radio" name="rb_accept" id="rb_accept" required>
                <label for="rb_accept" id="lb_block">
                  <?php echo $txt_conterms; ?> 
                  <a href="javascript:void;" data-toggle="modal" data-target="#termsModal"><?php echo $txt_terms; ?></a>
                  <?php echo $txt_and; ?>
                  <a href="javascript:void;" data-toggle="modal" data-target="#policyModal"><?php echo $txt_policy; ?></a>
                </label>
              </div>
              <div class="form-group text-center">
                <button type="button" class="btn btn_black" id="btn_register"><?php echo $txt_sign; ?></button>
              </div>
          </div>
          <div class="col-md-5">
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- LOGIN Modal -->
<div class="modal fade irinmodal" id="loginmodal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <div class="row">
          <div class="col-md-6 text-center">
            <h5 class="modal-title"><span><?php echo $txt_login; ?></span></h5>
          </div>
        </div>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <div class="error-message login-error-message"></div>
          </div>
          <div class="col-md-6">
            <div class="form-group login-margin">
              <input type="email" class="form-control" name="txt_login_email" id="txt_login_email" placeholder="<?php echo $txt_mail; ?>">
            </div>
            <div class="form-group">
              <input type="password" class="form-control" name="txt_login_pass" id="txt_login_pass" placeholder="<?php echo $txt_pass; ?>">
            </div>
            <div class="form-group text-center">
              <input type="checkbox" id="cb_keep" name="cb_keep"><label for="rb_accept" id="lb_block"><?php echo $txt_keep; ?></label>
            </div>
            <div class="form-group text-center">
              <button type="button" class="btn btn_black login-btn" id="btn_login"><?php echo $txt_login; ?></button>
            </div>
            <div class="form-group text-center forgotpass">
             <a href="#" class="link-signup"><?php echo $txt_sign; ?></a> | 
             <a href="#" data-toggle="modal" data-target="#forgot-password" id="menu-forgot"><?php echo $txt_forget; ?></a>
            </div>
          </div>
          <div class="col-md-6">
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade irinmodal2" id="logoutmodal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <div class="row" style="width: 100%;">
          <div class="col-md-6">
            <h5 class="modal-title"><?php echo $txt_confirm; ?></h5>
          </div>
        </div>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <?php echo $txt_confirm_logout; ?>
          </div>
        </div>
      </div>
       <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="btn_logout"><?php echo $txt_ok; ?></button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $txt_cancle; ?></button>
       </div>
    </div>
  </div>
</div>

<div class="modal fade irinmodal2" id="success-register" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <div class="row" style="width: 100%;">
          <div class="col-md-6" style="flex: 100%; max-width: 100%;">
            <h5 class="modal-title"><?php echo $txt_register_success; ?></h5>
          </div>
        </div>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12" style="padding: 1rem;">
            <?php echo $txt_register_desc; ?>
          </div>
        </div>
      </div>
       <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="btn_success"><?php echo $txt_ok; ?></button>
        <!--button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $txt_cancle; ?></button-->
       </div>
    </div>
  </div>
</div>

<div class="modal fade irinmodal" id="forgot-password" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <div class="row">
          <div class="col-md-6 text-center">
            <h5 class="modal-title"><?php echo $txt_forget; ?></h5>
          </div>
        </div>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <div class="row">
            <div class="form-group col-md-8">
              <label for="txt_mail_forgot"><h6><?php echo $txt_please_mail; ?></h6></label>
              <input type="mail" id="txt_mail_forgot" name="txt_mail_forgot" value="" class="form-control" placeholder="<?php echo $txt_mail; ?>">
            </div>
          </div>
          <div class="row">
            <div class="col-md-8">
              <div class="form-group text-center">
                <button type="button" class="btn btn_black login-btn" id="btn_forgot"><?php echo $txt_ok; ?></button>
              </div>
            </div>
          </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade irinmodal2" id="forgot-success" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <div class="row" style="width: 100%;">
          <div class="col-md-6" style="flex: 100%; max-width: 100%;">
            <h5 class="modal-title">
              <?php
              if($this->session->userdata('lang')=="EN"){
               echo "Reset password success.";
              }else{
                echo "เปลี่ยนรหัสผ่านเรียบร้อย";
              }
              ?>
            </h5>
          </div>
        </div>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12" style="padding: 1rem;">
             
             <?php
              if($this->session->userdata('lang')=="EN"){
               echo "Reset password successfully and send new password to your email.";
              }else{
                echo "ระบบได้ทำการส่งรหัสผ่านไปยังอีเมลของคุณเรียบร้อยแล้ว";
              }
              ?>
          </div>
        </div>
      </div>
       <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="btn_forgot_success"><?php echo $txt_ok; ?></button>
        <!--button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $txt_cancle; ?></button-->
       </div>
    </div>
  </div>
</div>

<div class="alert alert-success cartmessage" role="alert">
  <?php echo $txt_addtocart_text; ?>
</div>
<script  type="text/javascript" charset="utf-8" async defer>
  function removeCart(pid){
    $.post('<?php echo base_url('api/Cart/removeitem/format/json');?>', {id: pid}, function(resp) {
      window.location.reload();
    });
  }
  function addtocartmodal(){
     $('.cartmessage').fadeIn();
    setTimeout(function() {
      $('.cartmessage').fadeOut();
    }, 3000);
  }
  function loadCart(){
    $.get('<?php echo base_url('api/Cart/me/format/json');?>', function(data) {
      //console.log(data);
      var html ="<div class=\"arrow\"></div>";
      var subtotal = 0;
      var total = 0;
      var badge = 0;
      var weight = 0;
      var shipping = 0;
      $.each(data, function(i, item) {
        subtotal = +subtotal + +item.subtotal;
        badge = +badge + +item.qty;
        weight = +weight + (+item.weight* +item.qty);
        shipping = +shipping + +item.shipping;
        
        html +="<div class=\"dropdown-item\">";
        html +="<div class=\"row\">";
        html +="<div class=\"col-md-4 col-xs-4 col-sm-4\"><img src=\""+item.image+"\" alt=\"\"></div>";
        html +="<div class=\"col-md-8 col-xs-8 col-sm-8\">";
        html +="<a href=\"#\" onClick=\"removeCart("+item.id+");\"><span class=\"oi\" data-glyph=\"x\"></span></a>";
        html +="<h3>"+item.name+"</h3>";
        html +="<p>฿"+item.price+"</p>";
        html +="<p>"+item.qty+" <?php echo $txt_item;?></p>";
        html +="</div>";
        html +="</div>";
        html +="</div>";
      })
        total = subtotal;
        html +="<div class=\"dropdown-item cart-total\">";
        html +="<div class=\"row\">";
        html +="<div class=\"col\"><h3>"+"<?php echo $txt_subtotal; ?>"+"</h3></div>";
        html +="<div class=\"col text-right\"><h3>฿"+subtotal.toFixed(2)+"</h3></div>";
        html +="</div>";
       /* html +="<div class=\"row\">";
        html +="<div class=\"col\"><h3>"+"<?php echo $txt_shprate; ?>"+"</h3></div>";
        html +="<div class=\"col text-right\"><h3>฿"+shipping.toFixed(2)+"</h3></div>";
        html +="</div>";*/
        html +="<div class=\"row\">";
        html +="<div class=\"col\"><h3>"+"<?php echo $txt_gtotal; ?>"+"</h3></div>";
        html +="<div class=\"col text-right\"><h3>฿"+total.toFixed(2)+"</h3></div>";
        html +="</div>";
        html +="<div class=\"row cart-action\">";
        html +="<div class=\"col\">";
        html +="<div class=\"btn-irin2 text-left\">";
        html +="<a href=\"<?php echo base_url('Cart');?>\"><button type=\"button\">"+"<?php echo $txt_viewcart; ?>"+"</button></a>";
        html +="</div>";
        html +="</div>";
        html +="<div class=\"col text-right\">";
        html +="<div class=\"btn-irin text-right\">";
        html +="<a href=\"<?php echo base_url('Cart/Address');?>\"><button type=\"button\">"+"<?php echo $txt_checkout; ?>"+"</button></a>";
        html +="</div>";
        html +="</div>";
        html +="</div>";
        html +="</div>";
      $(".badge-cart").html(badge);
      $(".qty-item").html(badge);
      if(+badge <= 0){
        $(".badge-cart").hide();
      }else{
        $(".badge-cart").show();
      }
      $(".mycart").html(html);
    });
  }
  $(document).ready(function(){
    <?php
      $btn_txt_loding="";
      if($this->session->userdata('lang')=="EN"){
       $btn_txt_loding="Waiting...";
      }else{
       $btn_txt_loding="กรุณารอสักครู่ ...";
      }
    ?>
    loadCart();
    $("#btn_register").click(function(){
      <?php
        $btn_txt_loding="";
        if($this->session->userdata('lang')=="EN"){
         $btn_txt_loding="Waiting...";
        }else{
         $btn_txt_loding="กรุณารอสักครู่ ...";
        }
      ?>
      if($('#rb_accept').is(':checked')) {
        $.post("<?php echo base_url('api/V1/register/format/json');?>",{txt_name:$('#txt_name').val(),txt_email:$('#txt_email').val(),txt_pass:$('#txt_pass').val(),txt_repass:$('#txt_repass').val(),txt_tel:$('#txt_tel').val(),txt_line:$('#txt_line').val()},function(resp){
          $('#btn_register').html('<?php echo $btn_txt_loding;?>');
          $('#btn_register').attr('disabled','disabled');
          $.post("<?php echo base_url('Email/Registermail');?>",{email:$('#txt_email').val(),name:$('#txt_name').val()},function(resp){
            //window.location.reload();
            $("#registermodal").modal('hide');
            $('#success-register').modal();
          });
        }).fail(function(error) {
          $('.register-error-message').show();
          $('.register-error-message').html(error.responseJSON.error);
          console.log(error.responseJSON.error);
        });
      }
    });
    $("#btn_login").click(function(){     
      $.post("<?php echo base_url('api/V1/login/format/json');?>",{txt_email:$('#txt_login_email').val(),txt_pass:$('#txt_login_pass').val(),keep:$('#cb_keep').val()},function(resp){
        //console.log(resp);
          $('#btn_login').html('<?php echo $btn_txt_loding;?>');
          $('#btn_login').attr('disabled','disabled');
          window.location.reload();
      }).fail(function(error) {
          $('#btn_login').removeAttr('disabled');
          $('#btn_login').html('<?php echo $txt_login; ?>');
          $('.login-error-message').show();
          $('.login-error-message').html(error.responseJSON.error);
      });
    });
    $("#btn_logout").click(function(){      
      $('#btn_logout').html('<?php echo $btn_txt_loding;?>');
      $('#btn_logout').attr('disabled','disabled'); 
      window.location.href = "<?php echo base_url('Logout');?>";
    });
    $("#btn_success").click(function(){      
      $('#btn_success').html('<?php echo $btn_txt_loding;?>');
      $('#btn_success').attr('disabled','disabled'); 
      window.location.reload();
    });
    $("#user_signup").click(function(){
      //$("#loginmodal").modal('show');
      var fid = $('.signupnav span').find('m-d-none');
      if (fid) {
        $('.signupnav span').removeClass('m-d-none');
      }else{
        $('.signupnav span').addClass('m-d-none');
      }
    });
    $("#user_account").click(function(){
      window.location.href="<?php echo base_url('Profile');?>";
    });
    $(".link-signup").click(function(){
      $("#loginmodal").modal('hide');
      $("#registermodal").modal('show');
    });
    $(".lang").click(function(){
      $.get("<?php echo base_url("Lang");?>",{lang:$(this).data("code")},function(resp){
        window.location.reload();
      });
    });

    $('#menu-login').click(function(event) {
      $("#registermodal").modal('hide');
    });

    $('#menu-register').click(function(event) {
      $("#loginmodal").modal('hide');
    });

    $('#menu-forgot').click(function(event) {
      $("#loginmodal").modal('hide');
    });

    $('#btn_forgot_success').click(function(event) {
      window.location.reload();
    });

    $('#btn_forgot').click(function(event) {
      <?php
      $btn_txt_loding="";
      if($this->session->userdata('lang')=="EN"){
       $btn_txt_loding="Waiting...";
      }else{
       $btn_txt_loding="กรุณารอสักครู่ ...";
      }
      ?>
      $('#btn_forgot').html('<?php echo $btn_txt_loding;?>');
      $('#btn_forgot').attr('disabled','disabled');
      var email = $('#txt_mail_forgot').val();
      $.post('<?php echo base_url('api/V1/forgetpassword/format/json');?>', {txt_email: email}, function(resp) {
        //window.location.reload();
        $('#btn_forgot').html('<?php echo $txt_ok; ?>');
        $('#btn_forgot').removeAttr('disabled');
        $('#forgot-success').modal();
        $("#forgot-password").modal('hide');
        
      }).fail(function() {
        <?php
        $txt_alert="";
        if($this->session->userdata('lang')=="EN"){
         $txt_alert="Your email account incorrect.";
        }else{
         $txt_alert="อีเมล์ไม่ถูกต้องกรุณาลองใหม่อีกครั้ง";
        }
        ?>
        alert('<?php echo $txt_alert;?>');
        $('#btn_forgot').removeAttr('disabled');
        $('#btn_forgot').html('<?php echo $txt_ok; ?>');
        
      });
    });
  });
</script>