<div class="content-wrapper admin-container">
   <section class="content-header">
        <div style="float: left;">
            <h1>
                Product Purchase Report
            </h1>
        </div>
        <div style="float: right; padding-right: 20px;">
            <form action="<?php echo base_url('admin/Productpurchase/ExportExcel'); ?>" name="frm_export" method="post">
                <input type="hidden" name="hd_start" id="hd_start" value="<?php echo set_value('txt_start_date');?>">
                <input type="hidden" name="hd_end" id="hd_end" value="<?php echo set_value('txt_end_date');?>">
                <input type="hidden" name="hd_status" id="hd_status" value="<?php echo set_value('ddl_order_status');?>">
                <button type="submit" class="btn btn-success">Export</button>
            </form>
        </div>
        <div class="clearfix"></div>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-lg-9">
                <div class="box">
                    <div class="box-header">
                        <div class="btn-group floatRight btn-manage">
                            <!--button type="button" id="btn_new" class="btn btn-success" title="Create product" onClick="window.location='<?php echo base_url('admin/Order/Form');?>';"><i class="fa fa-file-o"></i> Create</button-->
                            <div class="clearPrefix">
                            </div>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive">  
                            <table class="table table-bordered table-hover" id="list_data">
                            	<thead>
                            		<th class="text-left">Product Code</th>
                                    <th class="text-left">Product Name</th>
                                    <th class="text-right">Quantity</th>
                                    <th class="text-right">Total</th>
                                </tr>
                            	</thead>
                               	<tbody>
                               		<?php
                                    if (isset($Products) && $Products) {
                                        foreach ($Products as $product) {
                                    ?>
                                    <tr>
                                        <td><?php echo $product['code'];?></td>
                                        <td><?php echo $product['product_name'];?></td>
                                        <td class="text-right"><?php echo $product['qty']; ?></td>
                                        <td class="text-right"><?php echo number_format($product['price'],2); ?></td>
                                    </tr>
                                    <?php } }else{ ?>
                                    <tr>
                                        <td colspan="4" align="center">No Information.</td>
                                    </tr>
                                    <?php } ?>                       		
                               	</tbody>                           
                            </table>
                        </div>
                        <div class="row">
                              <div class="tab_page floatRight m_nopage" align="center" style="width: 100%;">
                                  <div class="split"><?php echo $this->pagination->create_links();?></div>
                              </div>
                          </div>
                    </div>
                </div>
            </div>        
            <div class="col-lg-3">
               <form action="<?php echo base_url('admin/Productpurchase/Filter');?>" method="post">
                    <div class="card card-primary card-danger">
                    <div class="card-header">
                        <h5 class="card-title">
                            Filter
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    
                        <div class="card-body">
                             <div class="form-group">
                                <label>
                                    Start Date
                                </label>
                                <div class='input-group date' id='start_date'>
                                    <input type="text" name="txt_start_date" id="txt_start_date" value="<?php echo set_value('txt_start_date',$start_date);?>" class="form-control input" data-trigger="focus" readonly>
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar">
                                            </i>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>
                                    End Date
                                </label>
                                <div class='input-group date' id='end_date'>
                                    <input type="text" name="txt_end_date" id="txt_end_date" value="<?php echo set_value('txt_end_date',$end_date);?>" class="form-control input" data-trigger="focus" readonly>
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar">
                                            </i>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputPassword1">
                                    Order Status
                                </label>
                                <select class="form-control" name="ddl_order_status" id="ddl_order_status">
                                    <option value="0">-- Choose Status --</option>
                                    <?php
                                    foreach ($status as $item) {
                                    ?>
                                    <option value="<?php echo $item['id'];?>" <?php if(isset($ddl_order_status)){if($ddl_order_status==$item['id']){echo "selected=\"selected\"";}}?>><?php echo $item['status_text_en'];?></option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <button class="btn btn-primary" type="submit">
                                Filter
                            </button>
                        </div>
                </div>
                </form>
                
        	</div>           
        </div>
    </section>
</div>
<script type="text/javascript" charset="utf-8">
$(document).ready(function(){
    $('#start_date').datetimepicker({
      useCurrent: false,
      minView:2,
      format: 'yyyy-mm-dd',
      pickerPosition:'bottom-left',
      todayBtn : true,
      todayHighlight : true
    });
    $('#start_date').on('changeDate', function(ev){
        $(this).datetimepicker('hide');
    });
    $('#end_date').datetimepicker({
      useCurrent: false,
      minView:2,
      format: 'yyyy-mm-dd',
      pickerPosition:'bottom-left',
      todayBtn : true,
      todayHighlight : true
    });
    $('#end_date').on('changeDate', function(ev){
        $(this).datetimepicker('hide');
    });

    $('#txt_start_date').change(function(event) {
        $('#hd_start').val($('#txt_start_date').val());
    });
    $('#txt_end_date').change(function(event) {
        $('#hd_end').val($('#txt_end_date').val());
    });
    $('#ddl_order_status').change(function(event) {
        $('#hd_status').val($('#ddl_order_status').val());
    });
});
</script>
