<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>IRIN Admin | Dashboard</title>
	<!-- Tell the browser to be responsive to screen width -->
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  	<?php echo css_asset('bootstrap.min.css');?>
	
	<style type="text/css">
		.container{
			max-width: 700px !important;
		}
		td{
			width: 50%;
		}
	</style>
</head>
<body style="background-color: #cccccc;">
	<div class="container" style="margin-top:50px; background-color: #ffffff; padding: 50px 40px; width:688px;">
		<div class="row">
			<div class="col-lg-12">
				<h4>ใบสั่งซื้อเลขที่ #<?php echo $order->order_no;?></h4>
			</div>
		</div>
		<table class="table table-bordered"  style="font-family: 'Open Sans', sans-serif; font-size: 16px;">
			<thead>
				<tr>
					<th colspan="2">Order Details / รายละเอียดใบสั่งซื้อ</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						<address>
							<strong>บริษัท</strong><br> LUXNA Co., Ltd.
							<p>
								เลขที่ 1 ซอยอิสรภาพ 26 ถนนอิสรภาพ แขวงวัดกัลยาณ์ เขตธนบุรี กรุงเทพมหานคร 10600
							</p>
						</address>
						<b>เบอร์โทรศัพท์</b> 097-090-0659<br>
						<b>อีเมล์</b> info@irin.co.th<br>
						<b>เว็บไซต์:</b> 
						<a href="<?php echo base_url();?>" taget="_blank"><?php echo base_url();?></a>
					</td>
					<td>
						<b>วันที่สั่งซื้อ</b> <?php echo $order->rec_date;?><br>
						<b>ใบสั่งซื้อเลขที่:</b> <?php echo $order->order_no;?><br>

						<b>สถานะชำระเงิน</b> 
						<?php
						if($order->payment_status==="1"){
						    echo "รอชำระเงิน";
						}else if($order->payment_status==="2"){
						    echo "ชำระเงินแล้ว";
						}else{
						    echo "ยังไม่ชำระเงิน";
						}
						?>
						<br>
						<b>รูปแบบการจัดส่ง</b> <?php echo $order->shipping_name;?>
					</td>
				</tr>
			</tbody>
		</table>
		<table class="table table-bordered" style="font-family: 'Open Sans', sans-serif; font-size: 16px;">
			<thead>
				<tr>
					<th>Billing Address / ที่อยู่ใบเสร็จ</th>
					<th>Shipping Address / ที่อยู่ผู้รับ</th>
				</tr>
			</thead>
			<tbody>
              <tr>
                <td>
                	<strong><?php echo $shipping->cus_name." ".$shipping->cus_lastname;?></strong><br>
                	<?php echo $shipping->address;?><br>
                	<?php echo $shipping->subdistrict." ".$shipping->city." ".$shipping->province;?><br> 
                	<?php echo $shipping->country." ".$shipping->zipcode;?><br>
                	<?php echo $shipping->phone;?>
                </td>
                <td>
                	<strong><?php echo $billing->cus_name." ".$billing->cus_lastname;?></strong><br>
                	<?php echo $billing->address." ".$billing->subdistrict ;?><br>
                	<?php echo $billing->subdistrict." ".$billing->city." ".$billing->province;?><br> 
                	<?php echo $billing->country." ".$billing->zipcode;?><br>
                	<?php echo $billing->phone;?>
                </td>
              </tr>
			</tbody>
		</table>
		<?php
		if($privilege){
		?>
		<br>
		<table class="table table-bordered">
			<tr>
                <th>Promotion</th>
              </tr>
              <tr>
                <td>
                	<label><?php echo $privilege->title;?></label>
                	<p><?php echo $privilege->remark;?></p>
                </td>
              </tr>
		</table>
		<br>
		<?php }?>
		<table class="table table-bordered" style="font-family: 'Open Sans', sans-serif; font-size: 16px;">
			<thead>
				<tr>
	                <th>Code</th>
	                <th>Prodcut</th>
	                <th>Quantity</th>
	                <th>Unit Price</th>
	                <th>Total</th>
                </tr> 
			</thead>
			<tbody>
				<?php
              	foreach ($details as $product) {
              	?>
              		<tr>
	                    <td><?php echo $product['code'];?></td>
	                    <td><?php echo $product['product_name'];?></td>
	                    <td><?php echo $product['qty'];?></td>
	                    <td><?php echo number_format($product['price'],2);?></td>
	                    <td><?php echo number_format($product['qty']*$product['price'],2);?></td>
                    </tr>
                <?php
                }
                ?>
              <tr>
                <td colspan="4" style="text-align: right; font-weight: bold;">Sub-Total</td>
                <td class="text-right"><?php echo number_format($order->sub_total,2);?></td>
              </tr>
              <tr>
                <td colspan="4" style="text-align: right; font-weight: bold;">Flat Shipping Rate</td>
                <td class="text-right"><?php echo number_format($order->shipping_rate,2);?></td>
              </tr>
              <tr>
                <td colspan="4" style="text-align: right; font-weight: bold;">Total</td>
                <td class="text-right"><?php echo number_format($order->grand_total,2);?></td>
              </tr>
			</tbody>
		</table>
	</div>
</body>
</html>