<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Usersmodel extends CI_Model{
	public function Create($data)
	{
		$session_account = $this->session->userdata('logged_in');
		$account="";
		if($session_account){
			$account=$session_account['account'];
		}
		$date = new DateTime();
		$data_info=array(
			'name'=>strip_tags($data['txt_name']),
			'surname'=>strip_tags($data['txt_surname']),
			'account'=>strip_tags($data['txt_account']),
			'password'=>strip_tags(md5(md5(md5($data['txt_password'])))),
			'email'=>strip_tags($data['txt_email']),			
			'status'=>strip_tags($data['ddl_status']),
			'create_by'=>$account,
			'create_date'=>date_format($date, 'Y-m-d H:i:s'),
			'update_by'=>$account,
			'update_date'=>date_format($date, 'Y-m-d H:i:s'),
			'update_pass'=>date_format($date, 'Y-m-d H:i:s')
		);
		if($this->db->insert("tbl_admin",$data_info)){
			$new_id = $this->db->insert_id();
			if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])){				
				if (!is_dir('uploads/users/'.$new_id)) {
					mkdir('uploads/users/'.$new_id, 0777, TRUE);					
					$this->Upload($new_id,"profile");				
				}
			}
			redirect('admin/Users');
		}
	}

	public function Update($data)
	{
		$session_account = $this->session->userdata('logged_in');
		$account="";
		if($session_account){
			$account=$session_account['account'];
		}
		$date = new DateTime();
		$data_info=array(
			'name'=>strip_tags($data['txt_name']),
			'surname'=>strip_tags($data['txt_surname']),
			'email'=>strip_tags($data['txt_email']),
			'status'=>strip_tags($data['ddl_status']),
			'update_by'=>$account,
			'update_date'=>date_format($date, 'Y-m-d H:i:s')
		);
		$this->db->where("id",$data['hd_id']);
		if($this->db->update("tbl_admin",$data_info)){
			if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])){
				if (!is_dir('uploads/users/'.$data['hd_id'])) {
					mkdir('uploads/users/'.$data['hd_id'], 0777, TRUE);
					$this->Upload($data['hd_id'],"profile");			
				}else{
					$this->Upload($data['hd_id'],"profile");
					if(file_exists($data['hd_file_img'])){
						unlink($data['hd_file_img']);
					}
				}
			}
			return true;
		}else{
			return false;
		}
	}

	public function GetUsersList()
	{
		$this->db->select('*');
		$this->db->from('tbl_admin');
		$query = $this->db->get();
		if($query->num_rows()>0){
			return $query->result_array();
		}else{
			return false;
		}
	}

	public function GetUsersListById($id)
	{
		$this->db->select('*');
		$this->db->from('tbl_admin');
		$this->db->where('id',$id);
		$query = $this->db->get();
		if($query->num_rows()==1){
			return $query->row();
		}else{
			return false;
		}
	}

	public function CheckSigninByApp($data)
	{
		$this->db->select('*');
		$this->db->from('tbl_admin');
		$this->db->where('account',$data['name']);
		$this->db->where('password',md5(md5(md5($data['pass']))));
		$query = $this->db->get();
		if($query->num_rows()==1){
			return $query->row(); 
		}else{
			return false;
		}
	}

	public function CheckPassword($data)
	{
		$this->db->select('password');
		$this->db->from('tbl_admin');
		$this->db->where('id',$data['hd_repass']);
		$this->db->where('password',md5(md5(md5($data['txt_opassword']))));
		$query = $this->db->get();
		if($query->num_rows()==1){
			return true;
		}else{
			return false;
		}
	}

	public function ResetPassword($data)
	{
		$date = new DateTime();
		$data_info=array(
			'password'=>strip_tags(md5(md5(md5($data['txt_npassword'])))),
			'update_pass'=>date_format($date, 'Y-m-d H:i:s')
		);
		$this->db->where("id",$data['hd_repass']);
		if($this->db->update("tbl_admin",$data_info)){
			redirect('Admin');
		}
	}

	public function Delete($code)
	{
		$this->db->query("DELETE FROM tbl_admin WHERE  id='".$code."'");	
	}

	public function Upload($id,$file)
	{
		$this->load->library('upload');
		$m_config['upload_path'] ='uploads/users/'.$id;
		$m_config['allowed_types'] = 'gif|jpg|png';
		$m_config['max_size']    = '2000000';
		$m_config['max_width']  = '2000';
		$m_config['max_height']  = '2000';
		$m_config['file_name']  = md5($id);
		$this->upload->initialize($m_config);       
		if ( ! $this->upload->do_upload($file)){
			echo $this->upload->display_errors();
			$fname='';
		}else{
			$data_upload= $this->upload->data();
			$fname=$data_upload['file_name'];
			$filesize = $_FILES['profile']['name'];
			
			$data_info_file=array(
				"profile"=>'uploads/users/'.$id."/".$fname
			);
			$this->db->where("id",$id);
			$this->db->update("tbl_admin",$data_info_file);
		}
	}
}
?>