<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Summaryreportmodel extends CI_Model{

	public function GetBookingTotal()
	{
		$this->db->select('*');
		$this->db->from('tbl_booking');
		$this->db->where('payment_status','1');
		$this->db->order_by('rec_date','DESC');
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->num_rows();
		}else{
		  return false;
		}
	}

	public function GetBooking($start=0,$limit=25)
	{
		$this->db->select('*');
		$this->db->from('tbl_booking');
		$this->db->where('payment_status','1');
		$this->db->order_by('rec_date','DESC');
		$this->db->limit($limit,$start);
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}

	public function GetPackageById($bid,$pid)
	{
		$this->db->select('*');
		$this->db->from('tbl_booking_detail');
		$this->db->where('booking_id',$bid);
		$this->db->where('package_id',$pid);
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}

	public function Filter($data)
	{
		$this->load->library('customdate');
		$where="";
		$and="";
		if($data['txt_startdate']!="" && $data['txt_enddate']!=""){
			$where="DATE(rec_date) >= '".$this->customdate->Formatddmmyyyy($data['txt_startdate'])."' AND DATE(rec_date) <='".$this->customdate->Formatddmmyyyy($data['txt_enddate'])."'";
		}
		if($data['txt_startdate']!="" && $data['txt_enddate']==""){
			$where="DATE(rec_date) >= '".$this->customdate->Formatddmmyyyy($data['txt_startdate'])."'";
		}
		if($data['txt_startdate']=="" && $data['txt_enddate']!=""){
			$where="DATE(rec_date) <= '".$data['txt_enddate']."'";
		}
		$this->db->select('*');
		$this->db->from('tbl_booking');
		$this->db->where('payment_status','1');
		$this->db->where($where);
		$this->db->order_by('rec_date','DESC');
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}
	public function FilterExport($data)
	{
		$this->load->library('customdate');
		$where="";
		$and="";
		if($data['hd_start_date']!="" && $data['hd_end_date']!=""){
			$where="DATE(rec_date) >= '".$this->customdate->Formatddmmyyyy($data['hd_start_date'])."' AND DATE(rec_date) <='".$this->customdate->Formatddmmyyyy($data['hd_end_date'])."'";
		}
		if($data['hd_start_date']!="" && $data['hd_end_date']==""){
			$where="DATE(rec_date) >= '".$this->customdate->Formatddmmyyyy($data['hd_start_date'])."'";
		}
		if($data['hd_start_date']=="" && $data['hd_end_date']!=""){
			$where="DATE(rec_date) <= '".$data['hd_end_date']."'";
		}
		$this->db->select('*');
		$this->db->from('tbl_booking');
		$this->db->where('payment_status','1');
		$this->db->where($where);
		$this->db->order_by('rec_date','DESC');
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}
	public function ExportBooking()
	{
		$this->db->select('*');
		$this->db->from('tbl_booking');
		$this->db->where('payment_status','1');
		$this->db->order_by('rec_date','DESC');
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}
}
?>