<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   class Shippingratemodel extends CI_Model{
      function addShippingrate($data)
      {
         if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'shipping_name'=>strip_tags($data['txt_shipping_name']),
            'shipping_name_en'=>strip_tags($data['txt_shipping_name_en']),
            'shipping_rate'=>strip_tags($data['txt_shippingrate']),
            'remark'=>strip_tags($data['txt_remark']),
            'remark_en'=>strip_tags($data['txt_remark_en']),
            'status'=>strip_tags($data['ddl_status']),
            'rec_by'=>$session_data['account'],
            'rec_date'=>date_format($date, 'Y-m-d H:i:s')
         );
         if($this->db->insert("tbl_shipping_rate",$data_info)){
            return true;
         }else{
            return false;
         }
      }
      function UpdateShippingrate($data)
      {
         if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'shipping_name'=>strip_tags($data['txt_shipping_name']),
            'shipping_name_en'=>strip_tags($data['txt_shipping_name_en']),
            'shipping_rate'=>strip_tags($data['txt_shippingrate']),
            'remark'=>strip_tags($data['txt_remark']),
            'remark_en'=>strip_tags($data['txt_remark_en']),
            'status'=>strip_tags($data['ddl_status']),
            'update_by'=>$session_data['account'],
            'update_date'=>date_format($date, 'Y-m-d H:i:s')
         );
         $this->db->where("id",$data['hd_id']);
         if($this->db->update("tbl_shipping_rate",$data_info)){
            return true;
         }else{
            return false;
         }
      }
      public function getShippingrateTotal()
      {
         $this->db->select('*');
         $this->db->from('tbl_shipping_rate');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->num_rows();
         }else{
            return false;
         }
      }

      public function getShippingrate($start,$limit=25)
      {
         $this->db->select('*');
         $this->db->from('tbl_shipping_rate');
         $this->db->limit($limit,$start);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }

      public function getCurrentShippingrate($country=null)
      {
         $this->db->select('tbl_shipping_rate.*');
         $this->db->from('tbl_shipping_rate');
         $this->db->where('status','1');
         $this->db->limit(1);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }

      public function getShippingrateCountry()
      {
         $this->db->select('*');
         $this->db->from('tbl_country');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }

      public function getShippingratetById($id)
      {
         $this->db->select('*');
         $this->db->from('tbl_shipping_rate');
         $this->db->where('id',$id);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }
      public function getShippingrateActive()
      {
         $this->db->select('*');
         $this->db->from('tbl_shipping_rate');
         $this->db->where("status","1");
         $this->db->order_by("id","asc");
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }
      public function Delete($code)
      {
         $this->db->where('id', $code);
         if($this->db->delete('tbl_shipping_rate')){
            return true;
         }else{
            return false;
         }
      }
   }
?>