<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reportmodel extends CI_Model{
	public function GetSales($start=0,$limit=25,$startDate=null,$endDate=null,$status=null)
	{
		$this->db->select("DATE_FORMAT(tbl_order.rec_date,'%d-%m-%Y') as orderdate,count(order_no) as no_order,(SELECT SUM(qty) from tbl_order_detail where tbl_order_detail.order_no=tbl_order.order_no) as no_product,sum(shipping_rate) as shipping,sum(grand_total) as grantotal");
		$this->db->from('tbl_order');
		
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by("DATE_FORMAT(rec_date,'%Y-%m-%d')","DESC");
		$this->db->limit($limit,$start);
		
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}
	public function ExportSales($startDate=null,$endDate=null,$status=null)
	{
		$this->db->select("DATE_FORMAT(tbl_order.rec_date,'%d-%m-%Y') as orderdate,count(order_no) as no_order,(SELECT SUM(qty) from tbl_order_detail where tbl_order_detail.order_no=tbl_order.order_no) as no_product,sum(shipping_rate) as shipping,sum(grand_total) as grantotal");
		$this->db->from('tbl_order');
		
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=0){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by("DATE_FORMAT(rec_date,'%Y-%m-%d')","DESC");		
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}
	public function GetSalesTotal($startDate=null,$endDate=null,$status=null)
	{
		$this->db->select("DATE_FORMAT(tbl_order.rec_date,'%d-%m-%Y') as orderdate,count(order_no) as no_order,(SELECT SUM(qty) from tbl_order_detail where tbl_order_detail.order_no=tbl_order.order_no) as no_product,sum(shipping_rate) as shipping,sum(grand_total) as grantotal");
		$this->db->from('tbl_order');
		
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by("DATE_FORMAT(rec_date,'%Y-%m-%d')","DESC");
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->num_rows();
		}else{
		  return false;
		}
	}
	public function GetShipping($start=0,$limit=25,$startDate=null,$endDate=null,$status=null)
	{
		$this->db->select("DATE_FORMAT(tbl_order.rec_date,'%d-%m-%Y') as orderdate,count(order_no) as no_order,sum(shipping_rate) as shipping");
		$this->db->from('tbl_order');
		
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by("DATE_FORMAT(rec_date,'%Y-%m-%d')","DESC");
		$this->db->limit($limit,$start);
		
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}
	public function GetShippingTotal($startDate=null,$endDate=null,$status=null)
	{
		$this->db->select("DATE_FORMAT(tbl_order.rec_date,'%d-%m-%Y') as orderdate,count(order_no) as no_order,sum(shipping_rate) as shipping");
		$this->db->from('tbl_order');
		
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by("DATE_FORMAT(rec_date,'%Y-%m-%d')","DESC");

		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->num_rows();
		}else{
		  return false;
		}
	}
	public function getProductpurchase($start=0,$limit=25,$startDate=null,$endDate=null,$status=null){
		$this->db->select('tbl_product.code,product_name');
		$this->db->select_sum('tbl_order_detail.qty');
		$this->db->select_sum('tbl_order_detail.price');
		$this->db->from('tbl_order_detail');
		$this->db->join('tbl_order','tbl_order.order_no = tbl_order_detail.order_no');
		$this->db->join('tbl_product','tbl_product.id = tbl_order_detail.product_id');
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by('product_id');
		$this->db->limit($limit,$start);
	    $query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->result_array();
		}else{
			return false;
		}
	}

	public function ExportProductpurchase($startDate=null,$endDate=null,$status=null){
		$this->db->select('tbl_product.code,product_name');
		$this->db->select_sum('tbl_order_detail.qty');
		$this->db->select_sum('tbl_order_detail.price');
		$this->db->from('tbl_order_detail');
		$this->db->join('tbl_order','tbl_order.order_no = tbl_order_detail.order_no');
		$this->db->join('tbl_product','tbl_product.id = tbl_order_detail.product_id');
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=0){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by('product_id');
	    $query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->result_array();
		}else{
			return false;
		}
	}

	public function getProductpurchaseTotal($startDate=null,$endDate=null,$status=null){
		$this->db->select('tbl_product.code,product_name');
		$this->db->select_sum('tbl_order_detail.qty');
		$this->db->select_sum('tbl_order_detail.price');
		$this->db->from('tbl_order_detail');
		$this->db->join('tbl_order','tbl_order.order_no = tbl_order_detail.order_no');
		$this->db->join('tbl_product','tbl_product.id = tbl_order_detail.product_id');
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("order_status",$status);
		}
		$this->db->group_by('product_id');
	    $query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->num_rows();
		}else{
			return false;
		}
	}
	public function getCustomer($start=0,$limit=25,$startDate=null,$endDate=null,$status=4){
		$this->db->select ("tbl_customer.id,tbl_customer.name,tbl_customer.surname,tbl_customer.email,tbl_customer.type,tbl_customer.status,(select count(b_order.order_no) from tbl_order as b_order where b_order.cus_id = a_order.cus_id and b_order.payment_status = '2') as total_order,(select sum(p2_order.qty) from tbl_order_detail as p2_order,tbl_order as c_order where c_order.order_no = p2_order.order_no and c_order.cus_id=a_order.cus_id and c_order.payment_status='2') as total_qty,(select sum(c_order.grand_total) from tbl_order as c_order where c_order.cus_id = a_order.cus_id and c_order.payment_status = '2') as totalsumary");  
	     $this->db->from ( 'tbl_order as a_order');
	     $this->db->join ( 'tbl_customer', 'tbl_customer.id = a_order.cus_id');
	     $this->db->where ( 'a_order.payment_status','2');
	     
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("a_order.order_status",$status);
		}
		$this->db->group_by ( 'a_order.cus_id');
		$this->db->limit($limit,$start);
	    $query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->result_array();
		}else{
			return false;
		}
	}
	public function getCustomerTotal($startDate=null,$endDate=null,$status=4){
		$this->db->select ("tbl_customer.name,tbl_customer.email,tbl_customer.type,tbl_customer.status,(select count(b_order.order_no) from tbl_order as b_order where b_order.cus_id = a_order.cus_id and b_order.payment_status = '2') as total_order,(select sum(p2_order.qty) from tbl_order_detail as p2_order,tbl_order as c_order where c_order.order_no = p2_order.order_no and c_order.cus_id=a_order.cus_id and c_order.payment_status='2') as total_qty,(select sum(c_order.grand_total) from tbl_order as c_order where c_order.cus_id = a_order.cus_id and c_order.payment_status = '2') as totalsumary");  
         $this->db->from ( 'tbl_order as a_order');
         $this->db->join ( 'tbl_customer', 'tbl_customer.id = a_order.cus_id');
         
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=null){
			$this->db->where("a_order.order_status",$status);
		}
		$this->db->group_by ( 'a_order.cus_id' );
	    $query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->num_rows();
		}else{
			return false;
		}
	}

	public function getCustomerOder($id)
	{
		$this->db->select('id');
		$this->db->from('tbl_order');
		$this->db->where('cus_id',$id);
		$this->db->where('payment_status','2');
		$this->db->order_by('rec_date','DESC');
		$query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->result_array();
		}else{
			return false;
		}
	}
	public function getCustomerLastOder($id)
	{
		$this->db->select('*');
		$this->db->from('tbl_order');
		$this->db->where('cus_id',$id);
		$this->db->where('payment_status','2');
		$this->db->order_by('rec_date','DESC');
		$this->db->limit(1);
		$query=$this->db->get();
		if($query->num_rows()>0){
	 		$data = $query->row();
	 		return $data->rec_date;
		}else{
			return false;
		}
	}

	public function getOderDetail($id)
	{
		$this->db->select('*');
		$this->db->from('tbl_order_detail');
		$this->db->where('order_id',$id);
		$query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->result_array();
		}else{
			return false;
		}
	}

	public function getCustomerById($id)
	{
		$this->db->select('*');
		$this->db->from('tbl_customer');
		$this->db->where('id',$id);
		$query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->row();
		}else{
			return false;
		}
	}

	public function SummarySaleReport(){
		$this->db->select('DATE(rec_date) as y,SUM(grand_total) as item1');
		$this->db->from('tbl_order');
		$this->db->group_by('DATE(rec_date)');
		$this->db->order_by('rec_date','DESC');
		$this->db->limit(10);
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}
	}

	public function getCustomerToExcel($startDate=null,$endDate=null,$status=4){
		$this->db->select ("tbl_customer.name,tbl_customer.surname,tbl_customer.email,tbl_customer.type,tbl_customer.status,(select count(b_order.order_no) from tbl_order as b_order where b_order.cus_id = a_order.cus_id and b_order.payment_status = '2') as total_order,(select sum(p2_order.qty) from tbl_order_detail as p2_order,tbl_order as c_order where c_order.order_no = p2_order.order_no and c_order.cus_id=a_order.cus_id and c_order.payment_status='2') as total_qty,(select sum(c_order.grand_total) from tbl_order as c_order where c_order.cus_id = a_order.cus_id and c_order.payment_status = '2') as totalsumary");  
         $this->db->from ( 'tbl_order as a_order');
         $this->db->join ( 'tbl_customer', 'tbl_customer.id = a_order.cus_id');
         $this->db->where ( 'a_order.payment_status','2');
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			if($endDate!=null){
				$this->db->where("DATE_FORMAT(a_order.rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}
		if($status!=0){
			$this->db->where("a_order.order_status",$status);
		}
		$this->db->group_by ( 'a_order.cus_id' );
	    $query=$this->db->get();
		if($query->num_rows()>0){
	 		return $query->result_array();
		}else{
			return false;
		}
	}

	public function getShippingToExcel($startDate=null,$endDate=null,$status=0){
		$this->db->select("DATE_FORMAT(tbl_order.rec_date,'%d-%m-%Y') as orderdate,count(order_no) as no_order,sum(shipping_rate) as shipping");
		$this->db->from('tbl_order');
		
		if($startDate!=null&&$endDate!=null){
			$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') BETWEEN '".$startDate."' AND '".$endDate."'");
		}else{
			if($startDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') >= '".$startDate."'");
			}
			elseif($endDate!=null){
				$this->db->where("DATE_FORMAT(rec_date,'%Y-%m-%d') <= '".$endDate."'");
			}
		}

		if($status!=0){
			$this->db->where("order_status",$status);
		}

		$this->db->group_by("DATE_FORMAT(rec_date,'%Y-%m-%d')","DESC");
		$query = $this->db->get();
		if($query->num_rows()>0){
		  return $query->result_array();
		}else{
		  return false;
		}		
	}

	public function getProduct()
      {
         $this->db->select('*');
         $this->db->from('tbl_product');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }
}
?>