<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   class Ordermodel extends CI_Model{
      function addOrder($data)
      {
         
         if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'name'=>strip_tags($data['txt_name']),
            'short_desc'=>strip_tags($data['txt_shortdesc']),
            'desc'=>strip_tags($data['txt_desc']),
            'price'=>strip_tags($data['txt_price']),                      
            'status'=>strip_tags($data['ddl_status']),
            'create_by'=>$session_data['account'],
            'create_date'=>date_format($date, 'Y-m-d H:i:s'),
            'update_by'=>$session_data['account'],
            'update_date'=>date_format($date, 'Y-m-d H:i:s')
         );
         if($this->db->insert("tbl_order",$data_info)){
            $new_id = $this->db->insert_id();
            if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])){          
               if (!is_dir('uploads/order/'.$new_id)) {
                  mkdir('uploads/order/'.$new_id, 0777, TRUE);             
                  $this->Upload($new_id,"profile");            
               }
            }
            return true;
         }else{
            return false;
         }
      }

      public function updateOrder($data)
      {
        if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'name'=>strip_tags($data['txt_name']),
            'short_desc'=>strip_tags($data['txt_shortdesc']),
            'desc'=>strip_tags($data['txt_desc']),
            'price'=>strip_tags($data['txt_price']),                      
            'status'=>strip_tags($data['ddl_status']),
            'update_by'=>$session_data['account'],
            'update_date'=>date_format($date, 'Y-m-d H:i:s')
         );

         $this->db->where("id",$data['hd_id']);
         if($this->db->update("tbl_order",$data_info)){
            if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])) {
               if (!is_dir('uploads/order/'.$data['hd_id'])) {
                  mkdir('uploads/order/'.$data['hd_id'], 0777, TRUE);               
                  $this->Upload($data['hd_id'],"profile");        
               }else{
                  $this->Upload($data['hd_id'],"profile");
                  if(file_exists($data['hd_file_img'])){
                     unlink($data['hd_file_img']);
                  }
               }
            }
            return true;
         }else{
            return false;
         }
      }

      public function Upload($id,$file)
      {
         $this->load->library('upload');
         $m_config['upload_path'] ='uploads/order/'.$id;
         $m_config['allowed_types'] = 'gif|jpg|png';
         $m_config['max_size']    = '5000000';
         $m_config['max_width']  = '5000';
         $m_config['max_height']  = '5000';
         $m_config['file_name']  = md5($id);
         $this->upload->initialize($m_config);       
         if (!$this->upload->do_upload($file)){
            echo $this->upload->display_errors();
            $fname='';
         }else{
            $data_upload= $this->upload->data();
            $fname=$data_upload['file_name'];
            $filesize = $_FILES['profile']['name'];
            $data_info_file=array(
               "img"=>'uploads/order/'.$id."/".$fname
            );
            $this->db->where("id",$id);
            $this->db->update("tbl_order",$data_info_file);
         }
      }

      public function getOrder($start=0,$limit=10)
      {
         $this->db->select('tbl_order.*,cus_name,cus_lastname,status_text_en');
         $this->db->from('tbl_order');
         $this->db->join('tbl_order_address','tbl_order_address.order_id = tbl_order.id');
         $this->db->join('tbl_order_status','tbl_order_status.id = tbl_order.order_status');
         $this->db->order_by("rec_date","DESC");
         $this->db->limit($limit,$start);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }
      public function getOrderTotal()
      {
         $this->db->select('*');
         $this->db->from('tbl_order');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->num_rows();
         }else{
            return false;
         }
      }
      public function getInvoice($order_no){
         $this->db->select('*');
         $this->db->from('tbl_order');
         $this->db->where('order_no',$order_no);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }

      public function getShipping($order_no){
         $this->db->select('*');
         $this->db->from('tbl_order_address');
         $this->db->where('order_no',$order_no);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }
      public function getBilling($order_no){
         $this->db->select('*');
         $this->db->from('tbl_order_billing');
         $this->db->where('order_no',$order_no);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }
      public function getDetail($order_no){
         $this->db->select('tbl_order_detail.*,code');
         $this->db->from('tbl_order_detail');
         $this->db->join('tbl_product','tbl_order_detail.product_id=tbl_product.id');
         $this->db->where('order_no',$order_no);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }
      public function getOrderPrivilege($order_no){
        $this->db->select('tbl_order_privilege.*,title');
        $this->db->from('tbl_order_privilege');
        $this->db->join('tbl_privilege','tbl_privilege.id=tbl_order_privilege.privilege_id');
        $this->db->where('order_no',$order_no);
        $query=$this->db->get();
        if($query->num_rows()>0){
           return $query->row();
        }else{
           return false;
        }
      }
      public function getOrderById($id)
      {
         $this->db->select('*');
         $this->db->from('tbl_order');
         $this->db->where('id',$id);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }

      public function UpdateQTY($data)
      {
         $data_info=array(
            'qty'=>$data['qty']
         );

         $this->db->where("order_no",$data['code']);
         $this->db->where('product_id', $data['pid']);
         if($this->db->update("tbl_order_detail",$data_info)){
            return true;
         }else{
            return false;
         }
      }

      public function Delete($data)
      {
         $this->db->where('order_no', $data['code']);
         $this->db->where('product_id', $data['pid']);
         if($this->db->delete('tbl_order_detail')){
            return true;
         }else{
            return false;
         }
      }

      public function DeleteOder($oder_no)
      {
         $this->db->where('order_no', $oder_no);
         $this->db->delete(array('tbl_order','tbl_order_detail','tbl_order_additional','tbl_order_address','tbl_order_billing'));      
      }
      public function GetOrderStatus(){
         $this->db->select('*');
         $this->db->from('tbl_order_status');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }
      public function GetOrderStatusById($id){
         $this->db->select('*');
         $this->db->from('tbl_order_status');
         $this->db->where('id',$id);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }
      public function GetOrderHistory($order_no){
         $this->db->select('tbl_order_history.*,status_text_en as order_status_text');
         $this->db->from('tbl_order_history');
         $this->db->join('tbl_order_status','tbl_order_status.id=tbl_order_history.order_status');
         $this->db->where('order_no',$order_no);
         $this->db->order_by('rec_date','DESC');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }
      function addHistory($data)
      {
         if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $noti = 0;
         if(array_key_exists("cb_noti",$data))
         {
           $noti = $data['cb_noti'];
         } 
         $date = new DateTime();
         $data_info=array(
            "order_id"=>strip_tags($data['hd_order_id']),
            "order_no"=>strip_tags($data['hd_order_no']),
            "order_status"=>strip_tags($data['ddl_order_status']),
            "comment"=>strip_tags($data['txt_history_comment']),
            "customer_noti"=>$noti ,
            "rec_date"=>date_format($date, 'Y-m-d H:i:s'),
            "rec_by"=>$session_data['account']
         );
         if($this->db->insert("tbl_order_history",$data_info)){
            $this->UpdateOrderStatus($data['hd_order_no'],$data['ddl_order_status']);
            return true;
         }else{
            return false;
         }
      }
      public function UpdateOrderStatus($order_no,$order_status)
      {
         if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         } 
          $date = new DateTime();
          $data_info=array(
            "order_status"=>strip_tags($order_status),
            "update_date"=>date_format($date, 'Y-m-d H:i:s'),
            "update_by"=>$session_data['account']
         );
         $this->db->where('order_no', $order_no);
         if($this->db->update('tbl_order',$data_info)){
            return true;
         }else{
            return false;
         }
      }
      public function GetDailySale()
   {
      $date = new DateTime();
      $datetime_start = date_format($date, 'Y-m-d')." 00:00:00";
      $datetime_end = date_format($date, 'Y-m-d')." 23:23:59";
      $this->db->select('SUM(grand_total) as total');
      $this->db->from('tbl_order');
      $this->db->where("payment_status","2");
      $this->db->where("rec_date BETWEEN '".$datetime_start."' AND '".$datetime_end."'");
      $query = $this->db->get();
      if($query->num_rows()>0){
        $data=$query->row();
        return $data->total;
      }else{
        return false;
      }
   }
   public function GetMonthSale()
   {
      $date = new DateTime();
      $month = date_format($date, 'm');
      $this->db->select('SUM(grand_total) as total');
      $this->db->from('tbl_order');
      $this->db->where("payment_status","2");
      $this->db->where("MONTH(rec_date)",$month);
      $query = $this->db->get();
      if($query->num_rows()>0){
        $data=$query->row();
        return $data->total;
      }else{
        return false;
      }
   }
   public function GetYearSale()
   {
      $date = new DateTime();
      $year = date_format($date, 'Y');
      $this->db->select('SUM(grand_total) as total');
      $this->db->from('tbl_order');
      $this->db->where("payment_status","2");
      $this->db->where("YEAR(rec_date)",$year);
      $query = $this->db->get();
      if($query->num_rows()>0){
        $data=$query->row();
        return $data->total;
      }else{
        return false;
      }
   }

   public function GetShippingRate()
   {
      $this->db->select('*');
      $this->db->from('tbl_shipping_rate');
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->result_array();
      }else{
        return false;
      }
   }

   public function GetShippingRateById($id)
   {
      $this->db->select('*');
      $this->db->from('tbl_shipping_rate');
      $this->db->where('id',$id);
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->row();
      }else{
        return false;
      }
   }

   public function ChangeShipping($code,$data)
   {
      $data_info=array(
         'shipping_id'=>$data->id,
         'shipping_name'=>$data->shipping_name,
         'shipping_rate'=>$data->shipping_rate
      );
      $this->db->where('order_no',$code);
      if($this->db->update("tbl_order",$data_info)){
         return true;
      }else{
         return false;
      }
   }

   public function GetProducts()
   {
      $this->db->select('*');
      $this->db->from('tbl_product');
      $this->db->order_by('update_date','DESC');
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->result_array();
      }else{
        return false;
      }
   }

   public function GetProductById($id)
   {
      $this->db->select('name,price');
      $this->db->from('tbl_product');
      $this->db->where('id',$id);
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->row();
      }else{
        return false;
      }
   }

   public function GetOrderByCode($code)
   {
      $this->db->select('id,shipping_rate as srate');
      $this->db->from('tbl_order');
      $this->db->where('order_no',$code);
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->row();
      }else{
        return false;
      }
   }

   public function AddProduct($data,$order_id,$product)
   {
      $data_info=array(
         'order_id'=>$order_id->id,
         'order_no'=>$data['code'],
         'product_id'=>$data['pid'],
         'product_name'=>$product->name,
         'qty'=>$data['qty'],
         'price'=>$product->price
      );
      if($this->db->insert("tbl_order_detail",$data_info)){
         return true;
      }else{
         return false;
      }
   }

   public function AddProductByCode($data,$qty)
   {
      $data_info=array(
         'qty'=>$qty,
      );
      $this->db->where('order_no',$data['code']);
      $this->db->where('product_id',$data['pid']);
      if($this->db->update("tbl_order_detail",$data_info)){
         return true;
      }else{
         return false;
      }
   }

   public function CheckOrder($code,$pid)
   {
      $this->db->select('*');
      $this->db->from('tbl_order_detail');
      $this->db->where('order_no',$code);
      $this->db->where('product_id',$pid);
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->row();
      }else{
        return false;
      }
   }

   public function GetSumOrder($code)
   {
      $this->db->select('*');
      $this->db->from('tbl_order_detail');
      $this->db->where('order_no',$code);
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->result_array();
      }else{
        return false;
      }
   }

   public function UpdateOrderByCode($code,$subtotal,$grandtotal)
   {
      $data_info=array(
         'sub_total'=>$subtotal,
         'grand_total'=>$grandtotal
      );
      $this->db->where('order_no',$code);
      if($this->db->update("tbl_order",$data_info)){
         return true;
      }else{
         return false;
      }
   }

   public function UpdateShipping($data,$orderNo)
   {
      $shipping_info=array(
         "cus_name "=>strip_tags($data['txt_name']),
         "cus_lastname"=>strip_tags($data['txt_lastname']),
         "cus_email"=>strip_tags($data['txt_email']),
         "address"=>strip_tags($data['txt_address']),
         "country"=>strip_tags($data['txt_contry']),
         "province"=>strip_tags($data['txt_province']),
         "city"=>strip_tags($data['txt_city']),
         "subdistrict"=>strip_tags($data['txt_subdist']),
         "zipcode"=>strip_tags($data['txt_pos']),
         "phone"=>strip_tags($data['txt_tel']),
         "line_id"=>strip_tags($data['txt_line'])
      );
      $this->db->where('order_no',$orderNo);
      if($this->db->update("tbl_order_address",$shipping_info)){
         return true;
      }else{
         return false;
      }
   }

   public function UpdateBilling($data,$orderNo)
   {
      $billing_info=array(
         "cus_name "=>strip_tags($data['txt_bi_name']),
         "cus_lastname"=>strip_tags($data['txt_bi_lastname']),
         "address"=>strip_tags($data['txt_bi_address']),
         "country"=>strip_tags($data['txt_bi_contry']),
         "province"=>strip_tags($data['txt_bi_province']),
         "city"=>strip_tags($data['txt_bi_city']),
         "subdistrict"=>strip_tags($data['txt_bi_subdist']),
         "zipcode"=>strip_tags($data['txt_bi_pos']),
         "phone"=>strip_tags($data['txt_bi_tel'])
      );
      $this->db->where('order_no',$orderNo);
      if($this->db->update("tbl_order_billing",$billing_info)){
         return true;
      }else{
         return false;
      }
   }

   public function Filter($data)
   {     
      $status = $data['ddl_order_status'];
      $bdate = $data['txt_begin_date'];
      $edate = $data['txt_end_date'];
      $orderNo = $data['txt_orderno'];
      $cus = $data['txt_customer'];
      $this->db->select('*');
      $this->db->from('tbl_order');
      $this->db->join('tbl_order_address','tbl_order_address.order_no = tbl_order.order_no');
      $this->db->join('tbl_order_status','tbl_order_status.id = tbl_order.order_status');
      if ($status!="") {
         $this->db->where('tbl_order.order_status',$status);
      }         
      if ($bdate!="") {
         $this->db->where('tbl_order.update_date >=',$bdate);
      }
      if ($edate!="") {
         $this->db->where('tbl_order.update_date <=',$edate);
      }
      if ($orderNo!="") {
         $this->db->like('tbl_order.order_no',$orderNo);
      }
      if ($cus!="") {
         $this->db->like('tbl_order_address.cus_name',$cus);
      }
      $query = $this->db->get();
      if($query->num_rows()>0){
        return $query->result_array();
      }else{
        return false;
      }
   }
}
?>