<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   class Articlemodel extends CI_Model{
      function addArticle($data)
      {
         if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'title'=>strip_tags($data['txt_title']),
            'short_desc'=>strip_tags($data['txt_shortdesc']),
            'desc'=>$data['txt_desc'],
            'author'=>strip_tags($data['txt_author']),
            'title_en'=>strip_tags($data['txt_title_en']),
            'short_desc_en'=>strip_tags($data['txt_shortdesc_en']),
            'desc_en'=>$data['txt_desc_en'],
            'author_en'=>strip_tags($data['txt_author_en']),
            'btitle'=>strip_tags($data['txt_btitle']),
            'bsubtitle'=>strip_tags($data['txt_bsubtitle']),
            'btitle_en'=>strip_tags($data['txt_btitle_en']),
            'bsubtitle_en'=>strip_tags($data['txt_bsubtitle_en']),
            'meta_auth'=>strip_tags($data['txt_metaaut']),
            'meta_key'=>strip_tags($data['txt_metakey']),
            'meta_desc'=>strip_tags($data['txt_metadesc']),
            'tags'=>strip_tags($data['txt_tags']),          
            'status'=>strip_tags($data['ddl_status']),
            'create_by'=>$session_data['account'],
            'create_date'=>date_format($date, 'Y-m-d H:i:s'),
            'update_by'=>$session_data['account'],
            'update_date'=>date_format($date, 'Y-m-d H:i:s')
         );
         if($this->db->insert("tbl_article",$data_info)){
            $new_id = $this->db->insert_id();
            if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])){          
               if (!is_dir('uploads/article/'.$new_id)) {
                  mkdir('uploads/article/'.$new_id, 0777, TRUE);             
                  $this->Upload($new_id,"profile");            
               }
            }
            if(isset($_FILES['banner']['name']) && !empty($_FILES['banner']['name'])){          
               if (!is_dir('uploads/article/'.$new_id.'/banner')) {
                  mkdir('uploads/article/'.$new_id.'/banner', 0777, TRUE);             
                  $this->UploadBanner($new_id,"banner");            
               }
            }
            return true;            
         }else{
            return false;
         }
      }

      public function updateArticle($data)
      {
        if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'title'=>strip_tags($data['txt_title']),
            'short_desc'=>strip_tags($data['txt_shortdesc']),
            'desc'=>$data['txt_desc'],
            'author'=>strip_tags($data['txt_author']),
            'title_en'=>strip_tags($data['txt_title_en']),
            'short_desc_en'=>strip_tags($data['txt_shortdesc_en']),
            'desc_en'=>$data['txt_desc_en'],
            'author_en'=>strip_tags($data['txt_author_en']),  
            'btitle'=>strip_tags($data['txt_btitle']),
            'bsubtitle'=>strip_tags($data['txt_bsubtitle']), 
            'btitle_en'=>strip_tags($data['txt_btitle_en']),
            'bsubtitle_en'=>strip_tags($data['txt_bsubtitle_en']),
            'meta_auth'=>strip_tags($data['txt_metaaut']),
            'meta_key'=>strip_tags($data['txt_metakey']),
            'meta_desc'=>strip_tags($data['txt_metadesc']),
            'tags'=>strip_tags($data['txt_tags']),                    
            'status'=>strip_tags($data['ddl_status']),
            'update_by'=>$session_data['account'],
            'update_date'=>date_format($date, 'Y-m-d H:i:s')
         );

         $this->db->where("id",$data['hd_id']);
         if($this->db->update("tbl_article",$data_info)){
            if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])) {
               if (!is_dir('uploads/article/'.$data['hd_id'])) {
                  mkdir('uploads/article/'.$data['hd_id'], 0777, TRUE);               
                  $this->Upload($data['hd_id'],"profile");        
               }else{
                  $this->Upload($data['hd_id'],"profile");
                  if(file_exists($data['hd_file_img'])){
                     unlink($data['hd_file_img']);
                  }
               }
            }
            if(isset($_FILES['banner']['name']) && !empty($_FILES['banner']['name'])) {
               if (!is_dir('uploads/article/'.$data['hd_id'].'/banner')) {
                  mkdir('uploads/article/'.$data['hd_id'].'/banner', 0777, TRUE);               
                  $this->UploadBanner($data['hd_id'],"banner");        
               }else{
                  $this->UploadBanner($data['hd_id'],"banner");
                  if(file_exists($data['hd_banner'])){
                     unlink($data['hd_banner']);
                  }
               }
            }
            return true;
         }else{
            return false;
         }
      }
      public function Recommended($tbl,$id,$status)
      {
        if($this->session->userdata('logged_in'))
         {
            $session_data = $this->session->userdata('logged_in');
         }  
         $date = new DateTime();
         $data_info=array(
            'recommend'=>strip_tags($status),                    
            'update_by'=>$session_data['account'],
            'update_date'=>date_format($date, 'Y-m-d H:i:s')
         );

         $this->db->where("id",$id);
         if($this->db->update($tbl,$data_info)){
            return true;
         }else{
            return false;
         }
      }
      public function Upload($id,$file)
      {
         $this->load->library('upload');
         $this->load->library('createimage'); // load Image library
         $this->load->library('image_lib');
         $m_config['upload_path'] ='uploads/article/'.$id;
         $m_config['allowed_types'] = 'gif|jpg|png';
         $m_config['max_size']    = '5000000';
         $m_config['max_width']  = '5000';
         $m_config['max_height']  = '5000';
         $m_config['file_name']  = md5($id);
         $this->upload->initialize($m_config);       
         if (!$this->upload->do_upload($file)){
            echo $this->upload->display_errors();
            $fname='';
         }else{
            /*$data_upload= $this->upload->data();
            $fname=$data_upload['file_name'];
            $filesize = $_FILES['profile']['name'];
            $data_info_file=array(
               "img"=>'uploads/article/'.$id."/".$fname
            );
            $this->db->where("id",$id);
            $this->db->update("tbl_article",$data_info_file);*/
            $data_upload= $this->upload->data();
            $fname=$data_upload['file_name'];
            $filesize ='uploads/article/'.$id."/".$fname;  //add New  set file path
            list($width, $height) = getimagesize($filesize); //add New  Check image size
            $path='uploads/article/'.$id."/".$fname;  //add New  set path for create image
            if($width>604){ //add New  check image width
               $this->image_lib->clear(); //add New  clear image_lib
               $m_config2['image_library'] = 'gd2';
               $m_config2['source_image'] ='uploads/article/'.$id."/".$fname;       
               $m_config2['maintain_ratio'] = TRUE;
               $m_config2['master_dim'] = 'width'; // add new set dimansions fix width
               $m_config2['width'] = 604;
               $m_config2['height'] = 466;
               $m_config2['new_image'] ='uploads/article/'.$id."/".$fname;          
               $this->image_lib->initialize($m_config2);
               if(!$this->image_lib->resize())
               { 
                  $response = $this->upload->display_errors();
               }else{
                  $this->createimage->createlarg($path,604,466);
                  $response = $this->upload->data();
               }
            }else if($height>466){ //add New  check image width
               $this->image_lib->clear(); //add New  clear image_lib
               $m_config2['image_library'] = 'gd2';
               $m_config2['source_image'] ='uploads/article/'.$id."/".$fname;       
               $m_config2['maintain_ratio'] = TRUE;
               $m_config2['master_dim'] = 'height'; // add new set dimansions fix width
               $m_config2['height'] = 466;
               $m_config2['new_image'] ='uploads/article/'.$id."/".$fname;          
               $this->image_lib->initialize($m_config2);
               if(!$this->image_lib->resize())
               { 
                  $response = $this->upload->display_errors();
               }else{
                  $this->createimage->createlarg($path,604,466);
                  $response = $this->upload->data();
               }
            }else{
               $this->createimage->createlarg($path,604,466);
               $response = $this->upload->data();
            }
            $data_info_file=array(
               "img"=>'uploads/article/'.$id."/".$fname
            );
            $this->db->where("id",$id);
            $this->db->update("tbl_article",$data_info_file);
         }
      }

      public function UploadBanner($id,$file)
      {
         $this->load->library('upload');
         $this->load->library('createimage'); // load Image library
         $this->load->library('image_lib');
         $m_config['upload_path'] ='uploads/article/'.$id.'/banner/';
         $m_config['allowed_types'] = 'gif|jpg|png';
         $m_config['max_size']    = '5000000';
         $m_config['max_width']  = '5000';
         $m_config['max_height']  = '5000';
         $m_config['file_name']  = md5($id);
         $this->upload->initialize($m_config);       
         if (!$this->upload->do_upload($file)){
            echo $this->upload->display_errors();
            $fname='';
         }else{
            /*$data_upload= $this->upload->data();
            $fname=$data_upload['file_name'];
            $filesize = $_FILES['profile']['name'];
            $data_info_file=array(
               "banner"=>'uploads/article/'.$id."/banner/".$fname
            );
            $this->db->where("id",$id);
            $this->db->update("tbl_article",$data_info_file);*/
            $data_upload= $this->upload->data();
            $fname=$data_upload['file_name'];
            $filesize ='uploads/article/'.$id."/banner/".$fname;  //add New  set file path
            list($width, $height) = getimagesize($filesize); //add New  Check image size
            $path='uploads/article/'.$id."/banner/".$fname;  //add New  set path for create image
            if($width>2200){ //add New  check image width
               $this->image_lib->clear(); //add New  clear image_lib
               $m_config2['image_library'] = 'gd2';
               $m_config2['source_image'] ='uploads/article/'.$id."/banner/".$fname;       
               $m_config2['maintain_ratio'] = TRUE;
               $m_config2['master_dim'] = 'width'; // add new set dimansions fix width
               $m_config2['width'] = 2200;
               $m_config2['height'] = 773;
               $m_config2['new_image'] ='uploads/article/'.$id."/banner/".$fname;          
               $this->image_lib->initialize($m_config2);
               if(!$this->image_lib->resize())
               { 
                  $response = $this->upload->display_errors();
               }else{
                  $this->createimage->createlarg($path,2200,773);
                  $response = $this->upload->data();
               }
            }else if($height>773){ //add New  check image width
               $this->image_lib->clear(); //add New  clear image_lib
               $m_config2['image_library'] = 'gd2';
               $m_config2['source_image'] ='uploads/article/'.$id."/banner/".$fname;       
               $m_config2['maintain_ratio'] = TRUE;
               $m_config2['master_dim'] = 'height'; // add new set dimansions fix width
               $m_config2['height'] = 773;
               $m_config2['new_image'] ='uploads/article/'.$id."/banner/".$fname;          
               $this->image_lib->initialize($m_config2);
               if(!$this->image_lib->resize())
               { 
                  $response = $this->upload->display_errors();
               }else{
                  $this->createimage->createlarg($path,2200,773);
                  $response = $this->upload->data();
               }
            }else{
               $this->createimage->createlarg($path,2200,773);
               $response = $this->upload->data();
            }
            $data_info_file=array(
               "banner"=>'uploads/article/'.$id."/banner/".$fname
            );
            $this->db->where("id",$id);
            $this->db->update("tbl_article",$data_info_file);
         }
      }

      public function getArticleTotal()
      {
         $this->db->select('*');
         $this->db->from('tbl_article');
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->num_rows();
         }else{
            return false;
         }
      }

      public function getArticle($start,$limit=25)
      {
         $this->db->select('*');
         $this->db->from('tbl_article');
         $this->db->limit($limit,$start);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }

      public function getArticleById($id)
      {
         $this->db->select('*');
         $this->db->from('tbl_article');
         $this->db->where('id',$id);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }

      public function Delete($code)
      {
         $this->db->where('id', $code);
         if($this->db->delete('tbl_article')){
            return true;
         }else{
            return false;
         }
      }
      
      public function FilterTotal($data)
      {
         $keyword = $data['txt_title'];
         $recommend = $data['ddl_recommend'];
         $this->db->select('*');
         $this->db->from('tbl_article');
         if($recommend!="" && $keyword!=""){
            $this->db->like('recommend',$recommend);
            $this->db->like('title',$keyword);
            $this->db->like('title_en',$keyword);
         }
         if ($recommend=="" && $keyword!="") {
            $this->db->like('title',$keyword);
            $this->db->like('title_en',$keyword);
         }
         if ($recommend!="" && $keyword=="") {
            $this->db->like('recommend',$recommend);
         }
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->num_rows();
         }else{
            return false;
         }
      }

      public function Filter($start,$data,$limit=25)
      {
         $keyword = $data['txt_title'];
         $recommend = $data['ddl_recommend'];
         $this->db->select('*');
         $this->db->from('tbl_article');
         if($recommend!="" && $keyword!=""){
            $this->db->where('recommend',$recommend);
            $this->db->like('title',$keyword);
            $this->db->like('title_en',$keyword);
         }
         if ($recommend=="" && $keyword!="") {
            $this->db->like('title',$keyword);
            $this->db->or_like('title_en',$keyword);
         }
         if ($recommend!="" && $keyword=="") {
            $this->db->like('recommend',$recommend);
         }
         $this->db->limit($limit,$start);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }

   }
?>