<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ordermodel extends CI_Model{

  public function Order($data,$carts,$shippings)
  {
    $this->load->library('user_agent');
    $cusId="";
    if($this->session->userdata('cus_logged_in'))
     {
        $session_data = $this->session->userdata('cus_logged_in');
        $cusId=$session_data['id'];
     }  
    $date = new DateTime();
    $orderNo = $this->GenerateCode();
    $subtotal = 0;
    $grandtotal = 0;
    $weight = 0;
    $shipping_rate = $shippings->shipping_rate;
    foreach($carts as $item) {
      $subtotal = $subtotal + $item['subtotal'];
      $weight = $item['weight']*$item['qty'];
    }
    
    $grandtotal = $shipping_rate + $subtotal;
    // INSERT ORDER INFO ================================================================================
    $order_info=array(
      "order_no"=>$orderNo,
      "sub_total"=>$subtotal,
      "grand_total"=>$grandtotal,
      "shipping_id"=>$shippings->id,
      "shipping_name"=>$shippings->shipping_name,
      "shipping_rate"=>$shipping_rate,
      "ip_address"=>$this->input->ip_address(),
      "cus_id"=>$cusId,
      "lang"=>$this->session->userdata('lang'),
      "rec_date"=> date_format($date, 'Y-m-d H:i:s'),
      "rec_by"=>$cusId
    );
    $this->db->insert("tbl_order",$order_info);
    $order_id = $this->db->insert_id();

    // INSERT ORDER DETAIL ================================================================================
    foreach($carts as $item) {
      $orderdetail_info=array(
        "order_id"=>$order_id,
        "order_no"=>$orderNo,
        "product_id"=>$item['id'],
        "product_name"=>$item['name'],
        "qty"=>$item['qty'],
        "price"=>$item['price']
      );
      $this->db->insert("tbl_order_detail",$orderdetail_info);
    }

    // INSERT Shipping INFO ================================================================================
    $shipping_info=array(
      "order_id"=>$order_id,
      "order_no"=>$orderNo,
      "cus_name "=>strip_tags($data['txt_sh_name']),
      "cus_lastname"=>strip_tags($data['txt_sh_lastname']),
      "cus_email"=>strip_tags($data['txt_sh_email']),
      "address"=>strip_tags($data['txt_sh_address']),
      "country"=>strip_tags($data['txt_sh_contry']),
      "province"=>strip_tags($data['txt_sh_province']),
      "city"=>strip_tags($data['txt_sh_city']),
      "subdistrict"=>strip_tags($data['txt_sh_subdist']),
      "zipcode"=>strip_tags($data['txt_sh_pos']),
      "phone"=>strip_tags($data['txt_sh_tel']),
      "line_id"=>strip_tags($data['txt_sh_line'])
    );
    $this->db->insert("tbl_order_address",$shipping_info);

    // INSERT Billing INFO ================================================================================
    $billing_info=array(
      "order_id"=>$order_id,
      "order_no"=>$orderNo,
      "cus_name "=>strip_tags($data['txt_bi_name']),
      "cus_lastname"=>strip_tags($data['txt_bi_lastname']),
      "address"=>strip_tags($data['txt_bi_address']),
      "country"=>strip_tags($data['txt_bi_contry']),
      "province"=>strip_tags($data['txt_bi_province']),
      "city"=>strip_tags($data['txt_bi_city']),
      "subdistrict"=>strip_tags($data['txt_bi_subdist']),
      "zipcode"=>strip_tags($data['txt_bi_pos']),
      "phone"=>strip_tags($data['txt_bi_tel']),
    );
    $this->db->insert("tbl_order_billing",$billing_info); 

     // INSERT Billing INFO ================================================================================
    $agent_info=array(
      "order_id"=>$order_id,
      "order_no"=>$orderNo,
      "ip_address "=>$this->input->ip_address(),
      "forwarded_ip"=>$this->input->ip_address(),
      "user_agent"=>$this->agent->agent_string(),
      "accept_language"=>$this->agent->accept_lang()
    );
    $this->db->insert("tbl_order_additional",$agent_info); 

    // INSERT PRIVILEGE INFO ================================================================================
    if (array_key_exists("rb_privilege",$data)){
        $privilege_info=array(
          "order_id"=>$order_id,
          "order_no"=>$orderNo,
          "privilege_id"=>$data['rb_privilege'],
          "remark"=>$data['txt_privilege_additional']
        );
        $this->db->insert("tbl_order_privilege",$privilege_info);
    }
    $orders = $this->GetOrders($orderNo);
    return $orders;
  }
  public function GetOrders($orderNo)
  {
    $this->db->select('*');
    $this->db->from('tbl_order');
    $this->db->where('order_no',$orderNo);
    $query = $this->db->get();
    if($query->num_rows()>0){
      return $query->row();
    }else{
      return false;
    }
  }
  public function getDetail($order_no){
     $this->db->select('tbl_order_detail.*,code,img');
     $this->db->from('tbl_order_detail');
     $this->db->join('tbl_product','tbl_order_detail.product_id=tbl_product.id');
     $this->db->where('order_no',$order_no);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->result_array();
     }else{
        return false;
     }
  }
   public function getOrderPrivilege($order_no){
     $this->db->select('tbl_order_privilege.*,title,title_en');
     $this->db->from('tbl_order_privilege');
     $this->db->join('tbl_privilege','tbl_privilege.id=tbl_order_privilege.privilege_id');
     $this->db->where('order_no',$order_no);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->row();
     }else{
        return false;
     }
  }
  public function GetOrdersHistory($customer)
  {
    $this->db->select('tbl_order.*,status_text_en');
    $this->db->from('tbl_order');
    $this->db->join('tbl_order_status','tbl_order_status.id=tbl_order.order_status');
    $this->db->where('cus_id',$customer);
    $this->db->order_by('rec_date','desc');
    $query = $this->db->get();
    if($query->num_rows()>0){
      return $query->result_array();
    }else{
      return false;
    }
  }
  public function markAsPaid($order_id){
        $this->db->where('id',$order_id);
        $this->db->update("tbl_order",array('payment_status' => 2,'update_date'=>date('Y-m-d H:i:s')));
    }
    public function markAsPending($order_id){
        $this->db->where('id',$order_id);
        $this->db->update("tbl_order",array('payment_status' => 1,'update_date'=>date('Y-m-d H:i:s')));
    }
    public function markAsSentMail($order_id){
        $this->db->where('id',$order_id);
        $this->db->update("tbl_order",array('mailing' => 2,'update_date'=>date('Y-m-d H:i:s')));
    }
    public function markAsSendingMail($order_id){
        $this->db->where('id',$order_id);
        $this->db->update("tbl_order",array('mailing' => 1,'update_date'=>date('Y-m-d H:i:s')));
    }
    public function AddPaymentResp($data){
    if($this->db->insert("tbl_payments",$data)){
      return true;
    }else{
      return false;
    }
  }
  public function GenerateCode() {
    $date = new DateTime();
    $yymmdd = date_format($date, 'ymd')."-";
    $datetime_start = date_format($date, 'Y-m-d')." 00:00:00";
    $datetime_end = date_format($date, 'Y-m-d')." 23:23:59";
      $str="OR";
      $code="OR".$yymmdd."0001";
      $query = $this->db->query("SELECT id FROM tbl_order WHERE rec_date BETWEEN '".$datetime_start."' AND '".$datetime_end."' order by id DESC");
      if($query->num_rows()>0)
      {
         $num = $query->num_rows();
         switch(strlen($num+1)){
           case 1:{$str=$str.$yymmdd."000".($num+1);}break;
           case 2:{$str=$str.$yymmdd."00".($num+1);}break;
           case 3:{$str=$str.$yymmdd."0".($num+1);}break;
           case 4:{$str=$str.$yymmdd.($num+1);}break;
         }
         return  $str;
      }else{
        return $code;
      }
    }
  public function getInvoice($order_no){
     $this->db->select('tbl_order.*,status_text_en');
     $this->db->from('tbl_order');
     $this->db->join('tbl_order_status','tbl_order_status.id=tbl_order.order_status');
     $this->db->where('order_no',$order_no);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->row();
     }else{
        return false;
     }
  }
  public function getShipping($order_no){
     $this->db->select('*');
     $this->db->from('tbl_order_address');
     $this->db->where('order_no',$order_no);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->row();
     }else{
        return false;
     }
  }
  public function getBilling($order_no){
     $this->db->select('*');
     $this->db->from('tbl_order_billing');
     $this->db->where('order_no',$order_no);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->row();
     }else{
        return false;
     }
  }
  public function GetOrderStatus(){
     $this->db->select('*');
     $this->db->from('tbl_order_status');
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->result_array();
     }else{
        return false;
     }
  }
  public function GetOrderHistory($order_no){
     $this->db->select('tbl_order_history.*,status_text_en as order_status_text');
     $this->db->from('tbl_order_history');
     $this->db->join('tbl_order_status','tbl_order_status.id=tbl_order_history.order_status');
     $this->db->where('order_no',$order_no);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->result_array();
     }else{
        return false;
     }
  }
  public function getOrderById($id)
  {
     $this->db->select('*');
     $this->db->from('tbl_order');
     $this->db->where('id',$id);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return $query->row();
     }else{
        return false;
     }
  }
  public function orderVerified($order_no){
     $cusId ="";
    if($this->session->userdata('cus_logged_in'))
     {
        $session_data = $this->session->userdata('cus_logged_in');
        $cusId=$session_data['id'];
     }  
     $this->db->select('*');
     $this->db->from('tbl_order');
     $this->db->where('order_no',$order_no);
     $this->db->where('cus_id', $cusId);
     $query=$this->db->get();
     if($query->num_rows()>0){
        return true;
     }else{
        return false;
     }
  }
}
?>