<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bannermodel extends CI_Model{
	function addBanner($data)
  {
     if($this->session->userdata('logged_in'))
     {
        $session_data = $this->session->userdata('logged_in');
     }  
     $date = new DateTime();
     $data_info=array(
        'title'=>strip_tags($data['txt_title']),
        'subtitle'=>strip_tags($data['txt_subtitle']),        
        'title_en'=>strip_tags($data['txt_title_en']),
        'subtitle_en'=>strip_tags($data['txt_subtitle_en']), 
        'page'=>strip_tags($data['ddl_page']),
        'link'=>$data['txt_link'],
        'status'=>strip_tags($data['ddl_status']),
        'create_by'=>$session_data['account'],
        'create_date'=>date_format($date, 'Y-m-d H:i:s'),
        'update_by'=>$session_data['account'],
        'update_date'=>date_format($date, 'Y-m-d H:i:s')
     );
     if($this->db->insert("tbl_banner",$data_info)){
        $new_id = $this->db->insert_id();
        if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])){          
           if (!is_dir('uploads/banner/'.$new_id)) {
              mkdir('uploads/banner/'.$new_id, 0777, TRUE);             
              $this->UploadDesktop($new_id,"profile");            
           }
        }
        if(isset($_FILES['banner']['name']) && !empty($_FILES['banner']['name'])){          
           if (!is_dir('uploads/banner/'.$new_id.'/mobile')) {
              mkdir('uploads/banner/'.$new_id.'/mobile', 0777, TRUE);             
              $this->UploadMobile($new_id,"banner");            
           }
        }
        return true;            
     }else{
        return false;
     }
  }

  public function updateBanner($data)
  {
    if($this->session->userdata('logged_in'))
     {
        $session_data = $this->session->userdata('logged_in');
     }  
     $date = new DateTime();
     $data_info=array(
      'title'=>strip_tags($data['txt_title']),
      'subtitle'=>strip_tags($data['txt_subtitle']),        
      'title_en'=>strip_tags($data['txt_title_en']),
      'subtitle_en'=>strip_tags($data['txt_subtitle_en']), 
      'page'=>strip_tags($data['ddl_page']),
      'link'=>$data['txt_link'],
      'status'=>strip_tags($data['ddl_status']),
      'update_by'=>$session_data['account'],
      'update_date'=>date_format($date, 'Y-m-d H:i:s')
    );

     $this->db->where("id",$data['hd_id']);
     if($this->db->update("tbl_banner",$data_info)){
        if(isset($_FILES['profile']['name']) && !empty($_FILES['profile']['name'])) {
           if (!is_dir('uploads/banner/'.$data['hd_id'])) {
              mkdir('uploads/banner/'.$data['hd_id'], 0777, TRUE);               
              $this->UploadDesktop($data['hd_id'],"profile");        
           }else{
              $this->UploadDesktop($data['hd_id'],"profile");
              if(file_exists($data['hd_file_img'])){
                 unlink($data['hd_file_img']);
              }
           }
        }
        if(isset($_FILES['banner']['name']) && !empty($_FILES['banner']['name'])) {
           if (!is_dir('uploads/banner/'.$data['hd_id'].'/mobile')) {
              mkdir('uploads/banner/'.$data['hd_id'].'/mobile', 0777, TRUE);               
              $this->UploadMobile($data['hd_id'],"banner");        
           }else{
              $this->UploadMobile($data['hd_id'],"banner");
              if(file_exists($data['hd_banner'])){
                 unlink($data['hd_banner']);
              }
           }
        }
        return true;
     }else{
        return false;
     }
  }

  public function UploadDesktop($id,$file)
  {
     $this->load->library('upload');
     $this->load->library('createimage'); // load Image library
     $this->load->library('image_lib');
     $m_config['upload_path'] ='uploads/banner/'.$id;
     $m_config['allowed_types'] = 'gif|jpg|png';
     $m_config['max_size']    = '50000000';
     $m_config['max_width']  = '5000';
     $m_config['max_height']  = '5000';
     $m_config['file_name']  = md5($id);
     $this->upload->initialize($m_config);       
     if (!$this->upload->do_upload($file)){
        echo $this->upload->display_errors();
        $fname='';
     }else{
      $data_upload= $this->upload->data();
      $fname=$data_upload['file_name'];
      $filesize = $_FILES['profile']['name'];
      $data_info_file=array(
         "banner_desktop"=>'uploads/banner/'.$id."/".$fname
      );
      $this->db->where("id",$id);
      $this->db->update("tbl_banner",$data_info_file);
        /*$data_upload= $this->upload->data();
        $fname=$data_upload['file_name'];
        $filesize ='uploads/banner/'.$id."/".$fname;  //add New  set file path
        list($width, $height) = getimagesize($filesize); //add New  Check image size
        $path='uploads/banner/'.$id."/".$fname;  //add New  set path for create image
        if($width>2732){ //add New  check image width
           $this->image_lib->clear(); //add New  clear image_lib
           $m_config2['image_library'] = 'gd2';
           $m_config2['source_image'] ='uploads/banner/'.$id."/".$fname;       
           $m_config2['maintain_ratio'] = TRUE;
           $m_config2['master_dim'] = 'width'; // add new set dimansions fix width
           $m_config2['width'] = 2732;
           $m_config2['height'] = 960;
           $m_config2['new_image'] ='uploads/banner/'.$id."/".$fname;          
           $this->image_lib->initialize($m_config2);
           if(!$this->image_lib->resize())
           { 
              $response = $this->upload->display_errors();
           }else{
              $this->createimage->createlarg($path,2732,960);
              $response = $this->upload->data();
           }
        }else if($height>960){ //add New  check image width
           $this->image_lib->clear(); //add New  clear image_lib
           $m_config2['image_library'] = 'gd2';
           $m_config2['source_image'] ='uploads/banner/'.$id."/".$fname;       
           $m_config2['maintain_ratio'] = TRUE;
           $m_config2['master_dim'] = 'height'; // add new set dimansions fix width
           $m_config2['height'] = 960;
           $m_config2['new_image'] ='uploads/banner/'.$id."/".$fname;          
           $this->image_lib->initialize($m_config2);
           if(!$this->image_lib->resize())
           { 
              $response = $this->upload->display_errors();
           }else{
              $this->createimage->createlarg($path,2732,960);
              $response = $this->upload->data();
           }
        }else{
           $this->createimage->createlarg($path,2732,960);
           $response = $this->upload->data();
        }
        $data_info_file=array(
           "banner_desktop"=>'uploads/banner/'.$id."/".$fname
        );
        $this->db->where("id",$id);
        $this->db->update("tbl_banner",$data_info_file);*/
     }
  }

  public function UploadMobile($id,$file)
  {
     $this->load->library('upload');
     $this->load->library('createimage'); // load Image library
     $this->load->library('image_lib');
     $m_config['upload_path'] ='uploads/banner/'.$id.'/mobile/';
     $m_config['allowed_types'] = 'gif|jpg|png';
     $m_config['max_size']    = '50000000';
     $m_config['max_width']  = '5000';
     $m_config['max_height']  = '5000';
     $m_config['file_name']  = md5($id);
     $this->upload->initialize($m_config);       
     if (!$this->upload->do_upload($file)){
        echo $this->upload->display_errors();
        $fname='';
     }else{
      $data_upload= $this->upload->data();
      $fname=$data_upload['file_name'];
      $filesize = $_FILES['profile']['name'];
      $data_info_file=array(
         "banner_mobile"=>'uploads/banner/'.$id."/mobile/".$fname
      );
      $this->db->where("id",$id);
      $this->db->update("tbl_banner",$data_info_file);
        /*$data_upload= $this->upload->data();
        $fname=$data_upload['file_name'];
        $filesize ='uploads/banner/'.$id."/mobile/".$fname;  //add New  set file path
        list($width, $height) = getimagesize($filesize); //add New  Check image size
        $path='uploads/banner/'.$id."/mobile/".$fname;  //add New  set path for create image
        if($width>1125){ //add New  check image width
           $this->image_lib->clear(); //add New  clear image_lib
           $m_config2['image_library'] = 'gd2';
           $m_config2['source_image'] ='uploads/banner/'.$id."/mobile/".$fname;       
           $m_config2['maintain_ratio'] = TRUE;
           $m_config2['master_dim'] = 'width'; // add new set dimansions fix width
           $m_config2['width'] = 1125;
           $m_config2['height'] = 784;
           $m_config2['new_image'] ='uploads/banner/'.$id."/mobile/".$fname;          
           $this->image_lib->initialize($m_config2);
           if(!$this->image_lib->resize())
           { 
              $response = $this->upload->display_errors();
           }else{
              $this->createimage->createlarg($path,1125,784);
              $response = $this->upload->data();
           }
        }else if($height>784){ //add New  check image width
           $this->image_lib->clear(); //add New  clear image_lib
           $m_config2['image_library'] = 'gd2';
           $m_config2['source_image'] ='uploads/banner/'.$id."/mobile/".$fname;       
           $m_config2['maintain_ratio'] = TRUE;
           $m_config2['master_dim'] = 'height'; // add new set dimansions fix width
           $m_config2['height'] = 784;
           $m_config2['new_image'] ='uploads/banner/'.$id."/mobile/".$fname;          
           $this->image_lib->initialize($m_config2);
           if(!$this->image_lib->resize())
           { 
              $response = $this->upload->display_errors();
           }else{
              $this->createimage->createlarg($path,1125,784);
              $response = $this->upload->data();
           }
        }else{
           $this->createimage->createlarg($path,1125,784);
           $response = $this->upload->data();
        }
        $data_info_file=array(
           "banner_mobile"=>'uploads/banner/'.$id."/mobile/".$fname
        );
        $this->db->where("id",$id);
        $this->db->update("tbl_banner",$data_info_file);*/
     }
  }

  public function getBannerTotal()
    {
       $this->db->select('*');
       $this->db->from('tbl_banner');
       $query=$this->db->get();
       if($query->num_rows()>0){
          return $query->num_rows();
       }else{
          return false;
       }
    }

      public function getBanner($start,$limit=25)
      {
         $this->db->select('*');
         $this->db->from('tbl_banner');
         $this->db->order_by('page','ASC');
         $this->db->order_by('sort_by','ASC');
         $this->db->limit($limit,$start);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }

      public function getBannerHome($limit=3)
      {
         $this->db->select('*');
         $this->db->from('tbl_banner');
         $this->db->order_by('sort_by','ASC');
         $this->db->order_by('update_date','DESC');
         $this->db->limit($limit);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->result_array();
         }else{
            return false;
         }
      }

      public function getBannerById($id)
      {
         $this->db->select('*');
         $this->db->from('tbl_banner');
         $this->db->where('id',$id);
         $query=$this->db->get();
         if($query->num_rows()>0){
            return $query->row();
         }else{
            return false;
         }
      }

      public function Delete($code)
      {
         $this->db->where('id', $code);
         if($this->db->delete('tbl_banner')){
            return true;
         }else{
            return false;
         }
      }

      public function SortBy($data){
         for($x = 0; $x <count($data['sort']); $x++) {
            $data_info_file=array(
                  "sort_by"=>$data['sort'][$x]
               );
            $this->db->where("id",$data['sortid'][$x]);
            $this->db->update("tbl_banner",$data_info_file);
         } 
      }
}
?>