<?php

class Payment
{
    /*private static $secret_api = 'hiTFGhLzRif0';
    public static $payments = array(
        'merchant_id' => '764764000000948',
        'version' => '7.2',
        'currency' => '764'
    );*/
    /*/Production*/
    private static $secret_api = '99BC3BCAA8DBE4CACB6B2454C19B6B60811B7A5380CAA33CBDAC306121E10C2B';
    public static $payments = array(
        'merchant_id' => '764764000001344',
        'version' => '7.2',
        'currency' => '764'
    );
    private static $payment_response_fields = array(
        'version',
        'request_timestamp',
        'merchant_id',
        'order_id',
        'invoice_no',
        'currency',
        'amount',
        'transaction_ref',
        'approval_code',
        'eci',
        'transaction_datetime',
        'payment_channel',
        'payment_status',
        'channel_response_code',
        'channel_response_desc',
        'masked_pan',
        'stored_card_unique_id',
        'backend_invoice',
        'paid_channel',
        'paid_agent',
        'recurring_unique_id',
        'user_defined_1',
        'user_defined_2',
        'user_defined_3',
        'user_defined_4',
        'user_defined_5',
        'browser_info',
        'ippPeriod',
        'ippInterestType',
        'ippInterestRate',
        'ippMerchantAbsorbRate',
        'payment_scheme',
        'hash_value'
    );

    private static $payment_request_fields = array(
        'version',
        'merchant_id',
        'payment_description',
        'order_id',
        'invoice_no',
        'currency',
        'amount',
        'customer_email',
        'pay_category_id',
        'promoion',
        'promoion',
        'user_defined_1',
        'user_defined_2',
        'user_defined_3',
        'user_defined_4',
        'user_defined_5',
        'result_url_1',
        'result_url_2',
        'payment_option',
        'ipp_interest_type',
        'payment_expiry',
        'default_lang',
        'enable_store_card',
        'pan_masked',
        'stored_card_unique_id',
        'recurring',
        'order_prefix',
        'recurring_amount',
        'allow_accumulate',
        'max_accumulate_amount',
        'recurring_interval',
        'recurring_count',
        'charge_next_date',
        'charge_on_date',
        'statementDescriptor',
        'request_3ds'
    );

    /**
     * Billpayment constructor.
     */
    public function __construct()
    {

    }

    public function save_result($params = null)
    {
        $data = self::get_params($params);

        $CI =& get_instance();
        $CI->load->model('Ordermodel');
        $order_model = $CI->Ordermodel;

        $order_model->AddPaymentResp(array(
            'order_id' => $this->get_order_id($data),
            'returninv' => @$data['invoice_no'],
            'cardnumber' => @$data['masked_pan'],
            'amount' => @$data['amount']/100,
            'thamount' => @$data['amount']/100,
            'refcode' => @$data['transaction_ref'],
            'created' => date('Y-m-d H:i:s'),
            'ipaddress' => $CI->input->ip_address(),
            'header' => json_encode(getallheaders()),
            'body' => json_encode($_POST)
        ));
    }

    public function get_order_id($params = null){
        $data = self::get_params($params);

        return empty($data['order_id'])? false : $data['order_id'];
    }

    public function get_order_no($params = null){
        $data = self::get_params($params);

        return empty($data['invoice_no'])? false : $data['invoice_no'];
    }

    public function is_paid($params = null)
    {
        $data = self::get_params($params);
        $paid_status = array('000');
        $paid_field = 'payment_status';

        return isset($data[$paid_field]) && in_array($data[$paid_field], $paid_status);
    }

    public function is_pending($params = null)
    {
        $data = self::get_params($params);
        $paid_status = array('001');
        $paid_field = 'payment_status';

        return isset($data[$paid_field]) && in_array($data[$paid_field], $paid_status);
    }


    public function is_result_valid($params = null)
    {
        $data = self::get_params($params);
        //echo $data['hash_value']."======".$this->get_result_hash($data);
        return isset($data['hash_value']) && $this->get_result_hash($data) === $data['hash_value'];
    }

    public function get_result_hash($payment)
    {
        $payment_message_order = self::$payment_response_fields;

        $payment_message = '';
        foreach ($payment_message_order as $key) {
            if (!empty($payment[$key]) && $key !== 'hash_value') {
                $payment_message .= $payment[$key];
            }
        }
        //var_dump($payment);

        $hash = strtoupper(hash_hmac('sha1', $payment_message, self::$secret_api, false));
        return $hash;
    }

    public function parse_result()
    {

    }

    /**
     * @param array $data
     */
    public function getHashValue($payment = array())
    {

        $payment = array_merge($payment, self::$payments);
        $payment_message_order = self::$payment_request_fields;
        $payment['result_url_1'] = base_url('/Order/Result');
        $payment['result_url_2'] = base_url('/Order/Callback');
        $payment_message = '';
        foreach ($payment_message_order as $key) {
            if (!empty($payment[$key])) {
                $payment_message .= $payment[$key];
            }
        }

        //$payment['payment_message'] = $payment_message;
        $hash = strtoupper(hash_hmac('sha1', $payment_message, self::$secret_api, false));
        $payment['hash_value'] = $hash;

        return $payment;
    }

    public function log()
    {
        $file_dir = APPPATH . 'files/order/';
        $file_date = date('Y-m-d');
        $file_name = "order-{$file_date}.log";
        $file_path = $file_dir . $file_name;

        if (!file_exists($file_dir)) {
            mkdir($file_dir, 0777, true);
        }

        $content = "\n\n=========================== " . date('Y-m-d H:i:s') . " ===========================";
        $content .= "\nSERVER : \n" . var_export($_SERVER, true);
        $content .= "\nHEADER : \n" . var_export(getallheaders(), true);
        $content .= "\nGET : \n" . var_export($_GET, true);
        $content .= "\nPOST : \n" . var_export($_POST, true);
        $content .= "\nCOOKIE : \n" . var_export($_COOKIE, true);
        $content .= "\nPAYLOAD : \n" . var_export(file_get_contents('php://input'), true);
        $content .= "\n================================================================================\n\n";

        file_put_contents($file_path, $content, FILE_APPEND);
    }

    private static function get_params($params = null) 
    {
        $data = $_POST;

        if ($params) {
            $data = $params;
        }

        return $data;
    }
}

?>