<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'/libraries/REST_Controller.php';

class v1 extends REST_Controller{
	function __construct(){
        // Construct our parent class
        parent::__construct();
        $this->methods['user_get']['limit'] = 500; //500 requests per hour per user/key
        $this->methods['user_post']['limit'] = 100; //100 requests per hour per user/key
        $this->methods['user_delete']['limit'] = 50; //50 requests per hour per user/key
        $this->load->model('Productmodel');
        $this->load->model('Articlemodel');
        $this->load->model('Promotionmodel');
        $this->load->model('Reviewmodel');
        $this->load->model('Customermodel');
        $this->load->model('admin/Reportmodel');
        $this->load->helper('text');
    }
    public function error()
    {
        $this->response(array('error' => 'Respone fail !'), 404);
    }
    
    public function Loadmore_post()
    {
        $items = $this->Productmodel->GetProductMore($this->input->post('start'));
        if($items){
            $arr = array();
            foreach ($items as $item) {
               array_push($arr,$item);
            }
            $this->response($arr, 200);
        }else{
             $this->error();
        }
    }
    public function Articlemore_post()
    {
        $items = $this->Articlemodel->GetArticleMore($this->input->post('start'));
        if($items){
            $arr = array();
            $lang = $this->session->userdata('lang');
            foreach ($items as $item) {
                $item['tags']=explode(",", $item['tags']);
                if ($lang=="EN") {
                    $item['title']=$item['title_en'];
                    $item['short_desc']=$item['short_desc_en'];
                }else{
                    $item['title']=$item['title'];
                    $item['short_desc']=$item['short_desc'];
                }
                array_push($arr,$item);
            }
            $this->response($arr, 200);
        }else{
             $this->error();
        }
    }
    public function Promotionmore_post()
    {
        $items = $this->Promotionmodel->GetPromotionMore($this->input->post('start'));
        if($items){
            $arr = array();
            $lang = $this->session->userdata('lang');
            foreach ($items as $item) {
                $item['tags']=explode(",", $item['tags']);
                if ($lang=="EN") {
                    $item['title']=$item['title_en'];
                    $item['short_desc']=$item['short_desc_en'];
                }else{
                    $item['title']=$item['title'];
                    $item['short_desc']=$item['short_desc'];
                }
               array_push($arr,$item);
            }
            $this->response($arr, 200);
        }else{
             $this->error();
        }
    }
    public function Reviewmore_post()
    {
        $items = $this->Reviewmodel->GetReviewMore($this->input->post('start'));
        if($items){
            $arr = array();
            $lang = $this->session->userdata('lang');
            foreach ($items as $item) {
                $item['tags']=explode(",", $item['tags']);
                if ($lang=="EN") {
                    $item['title']=$item['title_en'];
                    $item['short_desc']=$item['short_desc_en'];
                }else{
                    $item['title']=$item['title'];
                    $item['short_desc']=$item['short_desc'];
                }
                array_push($arr,$item);
            }
            $this->response($arr, 200);
        }else{
             $this->error();
        }
    }
    public function login_post()
    {
        $keep = $this->input->post('keep');
        $email = $this->input->post('txt_email');
        $pass = $this->input->post('txt_pass');

        $error = array();
        if($this->validateemail($email)){
            $data = $this->Customermodel->Login($email,$pass);
            if($data){
                $this->response($data, 200);
            }else{
                 $this->response(array('error' => 'Your account or password incorrect.!'), 404);
            }
            
        }else{
                $this->response(array('error' => 'Your account or password incorrect.!'), 404);
        }
    }
    public function register_post()
    {
        $name = $this->input->post('txt_name');
        $email = $this->input->post('txt_email');
        $pass = $this->input->post('txt_pass');
        $repass = $this->input->post('txt_repass');
        $tel = $this->input->post('txt_tel');
        $line = $this->input->post('txt_line');
        $error = array();
        if($this->validatename($name)&&$this->validateemail($email)&&$this->validatepassword($pass,$repass)&&$this->validatename($tel)&&$this->validatename($line)){
            if($this->chkemailvalidate($email)){
                $data = $this->Customermodel->Create($this->input->post());
                $this->response($data, 200);
            }else{
                 $this->response(array('error' => 'This email is already used.'), 404);
            }
            
        }else{
               $this->response(array('error' => 'Your information not invaliad please try angain !'), 404);
        }
    }
    public function forgetpassword_post()
    {
        $txt_subject = "แจ้งเปลี่ยนรหัสผ่าน IRIN.CO.TH";
        $txt_message = "ระบบได้ทำการรีเซ็ทรหัสผ่านของคุณเรียบร้อยแล้ว คุณสามารถใช้งานรหัสผ่าน ด้านล่างนี้ได้เลยค่ะ";
        $txt_pass = "รหัสผ่านใหม่ :";
        if($this->session->userdata('lang')){
            if($this->session->userdata('lang')=="EN"){
                $txt_subject = "Reset Password IRIN.CO.TH";
                $txt_message = "Your reset password has been successfully used. You can use the password below.";
                $txt_pass = "New Password :";
            }
        }
        $email = $this->input->post('txt_email');
        $error = array();
        if(!$this->chkemailvalidate($email)){
            $pass = $this->generateRandomString(8);
            $data = $this->Customermodel->ChangePassword($email,$pass);
            if($data){
                $this->load->model('admin/Settingmodel');
                $info = $this->Settingmodel->GetSetting();
                $subject=$txt_subject;
                $message = $txt_message;
                $pass_text = $pass;
                $config = Array(
                    'protocol' => 'smtp',
                    'smtp_host' => $info->hostname,
                    'smtp_port' => $info->port,
                    'smtp_user' => $info->username, // change it to yours
                    'smtp_pass' => $info->password, // change it to yours
                    'mailtype' => 'html',
                    'charset' => 'utf-8',
                    'wordwrap' => TRUE
                );
                $ms="<div style=\"background-color: #e6e6e6; width: 500px; margin: auto; border-radius: 5px;\">";
                $ms.="<div align=\"center\" style=\"padding-top:30px;\"><strong>".$subject."</strong></div>";
                $ms.="<div style=\"padding:30px 30px 0;\">".$message."</div>";
                $ms.="<div style=\"padding:5px 30px 0;\"><strong>".$txt_pass."</strong>".$pass_text."<br><br></div>";

                $mailto = $email;
                $html = $ms;
                $this->load->library('email', $config);
                $this->email->set_newline("\r\n");
                $this->email->from($info->username,"IRIN.CO.TH");
                $this->email->to($mailto);
                $this->email->subject($subject);
                $this->email->message($html);
                if($this->email->send()){
                    $this->response(array('status' => 'Forgot password sucessfully.!'), 200);
                }else{
                    $this->response(array('error' => 'Your email  account incorrect.!'), 404);
                }
            }else{
                 $this->response(array('error' => 'Your email  account incorrect.!'), 404);
            }
            
        }else{
                $this->response(array('error' => 'Your email  account incorrect.!'), 404);
        }
    }
    public function validatename($name){
        if(trim($name)!=""){
            return true;
        }else{
            return false;
        }
    }
    public function validateemail($email){
        if(trim($email)!=""){
            return true;
        }else{
            return false;
        }
    }
    public function validatepassword($password,$confirmpassword){
        if(trim($password)!=""&&trim($confirmpassword)!=""){
            if($password==$confirmpassword){
               return true;
           }else{
               return false;
           }
            
        }else{
            return false;
        }
    }
    public function chkemailvalidate($email){
        if(trim($email)!=""){
           $data = $this->Customermodel->CheckEmail($email);
           if($data){
                return false;
           }else{
                return true;
           }
        }else{
            return false;
        }
    }
    public function SummarySale_get()
    {
        $Sales = $this->Reportmodel->SummarySaleReport();
        $arr = array();
        if($Sales){            
            foreach ($Sales as $sale) {
               array_push($arr,$sale);
            }
            $this->response($arr,200);
        }else{
             $this->error();
        }
    }
    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}