<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'/libraries/REST_Controller.php';

class Cart extends REST_Controller{
    function __construct(){
        // Construct our parent class
        parent::__construct();
        $this->methods['user_get']['limit'] = 500; //500 requests per hour per user/key
        $this->methods['user_post']['limit'] = 100; //100 requests per hour per user/key
        $this->methods['user_delete']['limit'] = 50; //50 requests per hour per user/key
        $this->load->model('Productmodel');
        $this->load->model('Customermodel');
        $this->load->model('admin/Shippingratemodel');
        $this->load->helper('text');
        $this->load->library('cart');
    }
    public function error()
    {
        $this->response(array('error' => 'Respone fail !'), 404);
    }
    
    public function me_get()
    {
        $carts = $this->cart->contents();
        if($carts){
            $this->response($carts, 200);
        }else{
             $this->error();
        }
    }
    public function shipping_post()
    {
        $pid = $this->input->post('id');
        $shipping = $this->Shippingratemodel->getShippingratetById($pid);
        if($shipping){
            $carts = $this->cart->contents();
            $arr=array(
                "shipping" => $shipping->shipping_rate,
                "total" => number_format($this->cart->total() + $shipping->shipping_rate,2)
            );
            if($carts){
                $this->response($arr, 200);
            }else{
                $this->error();
            }
        }else{
            $this->error();
        }
    }
    public function removeitem_post()
    {
        $pid = $this->input->post('id');
        $carts = $this->cart->contents();
        foreach($carts as $item){
            if($item['id']===$pid){
                $this->cart->remove($item['rowid']);
            }
        }
        $this->response(array("status"=>"success"), 200);
    }
}