<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->model('admin/Usersmodel');
		if(!$this->session->userdata('logged_in')){
		   redirect('admin/Login');
		}
	}
	public function index()
	{
		$data['lists'] = $this->Usersmodel->GetUsersList();
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/users',$data);
		$this->load->view('admin/footer');
	}
	public function Form()
	{
		$data['errortext']="";
		$data['action'] = 'Create';
		$data['actionTxt'] = 'Create';
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/users_form',$data);
		$this->load->view('admin/footer');
	}
	public function Create()
	{
		if($this->ChackValidateForm()) {
			$this->Usersmodel->Create($this->input->post());
		}else{			
			$data['errortext']="Error : Your information is incorrect. Please try again";
			$data['action'] = 'Create';
			$data['actionTxt'] = 'Create';
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/users_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Edit()
	{
		$data['errortext']="";
		$data['action'] = 'Update';
		$data['actionTxt'] = 'Edit';
		$users = $this->Usersmodel->GetUsersListById($this->uri->segment(4));

		if($users){
			if(!file_exists($users->profile)){
				$users->profile = base_url('assets/img/default.jpg');
			}else{
				$users->profile = base_url($users->profile);
			}
		}
		$data['list']=$users;
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/users_form',$data);
		$this->load->view('admin/footer');
	}

	public function Update()
	{
		if($this->Usersmodel->Update($this->input->post())){
			redirect('admin/Users');
		}else{
			$data['errortext']="Error : Your information is incorrect. Please try again";
			$data['action'] = 'Update';
			$data['actionTxt'] = 'Edit';
			$data['list'] = $this->Usersmodel->GetUsersListById($this->input->post('hd_id'));
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/users_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Repassword()
	{
		if ($this->ChackValidateUpdatePass()) {
			$result = $this->Usersmodel->CheckPassword($this->input->post());
			if($result){
				if($this->input->post('txt_npassword')==$this->input->post('txt_rpassword')){
					$this->Usersmodel->ResetPassword($this->input->post());
				}else{
					$data['unmatch'] = "* Password don't matching";
					$data['action'] = 'Update';
					$data['repass'] = 'unsuccess';
					$data['list'] = $this->Usersmodel->GetUsersListById($this->input->post('hd_repass'));
					$this->load->view('admin/header');
					$this->load->view('admin/menu');
					$this->load->view('admin/users_form',$data);
					$this->load->view('admin/footer');
				}
			}else{
				$data['wrongpass'] = "* Password is incorrect";
				$data['action'] = 'Update';
				$data['actionTxt'] = 'Edit';
				$data['repass'] = 'unsuccess';
				$data['list'] = $this->Usersmodel->GetUsersListById($this->input->post('hd_repass'));
				$this->load->view('admin/header');
				$this->load->view('admin/menu');
				$this->load->view('admin/users_form',$data);
				$this->load->view('admin/footer');
			}
		}else{
			$data['action'] = 'Update';
			$data['actionTxt'] = 'Edit';
			$data['repass'] = 'unsuccess';
			$data['list'] = $this->Usersmodel->GetUsersListById($this->input->post('hd_repass'));
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/users_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Delete()
	{
		$this->Usersmodel->Delete($this->input->post('id'));	
		$this->load->helper("file");
		$files=glob("uploads/profile/".$this->input->post('id')."/*");
		foreach($files as $file){ 
		 if(is_file($file)){
			unlink($file);
		  }
		}
		rmdir("uploads/profile/".$this->input->post('id'));
	}

	public function DeleteAll(){
		$this->load->helper("file");
		$data=$this->input->post();
		for($n=0;$n<count($data['cb_users']);$n++){
			$this->Usersmodel->Delete($data['cb_users'][$n]);
			$files=glob("uploads/profile/".$data['cb_users'][$n]."/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
				}
			}
			rmdir("uploads/profile/".$data['cb_users'][$n]);
		}
	}

	public function ChackValidateForm(){
		$ar=array(
			array(
				'field'=>'txt_account',
				'label'=>'account',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_password',
				'label'=>'password',
				'rules'=>'trim|required'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function ChackValidateUpdateForm(){
		$ar=array(

		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function ChackValidateUpdatePass(){
		$ar=array(
			array(
				'field'=>'txt_opassword',
				'label'=>'old password',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_npassword',
				'label'=>'new password',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_rpassword',
				'label'=>'re password',
				'rules'=>'trim|required'
			)
		);
		$this->form_validation->set_rules($ar);
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}
}
