<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SHippingreport extends CI_Controller {
	function __construct()
	{
		parent::__construct();
   		$this->load->model('admin/Ordermodel');
   		$this->load->model('admin/Settingmodel');
   		$this->load->model('admin/Reportmodel');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index(){
		$data['total_num']=$this->Reportmodel->GetShippingTotal();
		$config['base_url'] = base_url()."admin/Shippingreport/page";
		$config['total_rows'] = $data['total_num'];
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li class=\"page-item\">';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li  class=\'page-item\'>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li class=\'page-item\'>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li class=\'page-item\'>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li class=\'page-item\'>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['Shippings'] = $this->Reportmodel->GetShipping($data['start'],$config['per_page']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$date = new DateTime();
		$data['start_date']=date_format($date,'Y-m-d');
		$data['end_date']=date_format($date,'Y-m-d');
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/shippingreport',$data);
		$this->load->view('admin/footer');
	}

	public function page(){
		$data['total_num']=$this->Reportmodel->GetShippingTotal();
		$config['base_url'] = base_url()."admin/Shippingreport/page";
		$config['total_rows'] = $data['total_num'];
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li class=\"page-item\">';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li  class=\'page-item\'>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li class=\'page-item\'>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li class=\'page-item\'>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li class=\'page-item\'>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['Shippings'] = $this->Reportmodel->GetShipping($data['start'],$config['per_page']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$date = new DateTime();
		$data['start_date']=date_format($date,'Y-m-d');
		$data['end_date']=date_format($date,'Y-m-d');
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/shippingreport',$data);
		$this->load->view('admin/footer');
	}

	public function Filter(){
		if($this->input->post()){
			$start_date = null;
			if($this->input->post('txt_start_date')!=0){
				$start_date = $this->input->post('txt_start_date');
			}
			$end_date = null;
			if($this->input->post('txt_end_date')!=0){
				$end_date = $this->input->post('txt_end_date');
			}
			$order_status = null;
			if($this->input->post('ddl_order_status')!="0"){
				$order_status = $this->input->post('ddl_order_status');
				$data['ddl_order_status'] =  $this->input->post('ddl_order_status');
			}
			$data['total_num']=$this->Reportmodel->GetShippingTotal($start_date,$end_date,$order_status);
			$config['base_url'] = base_url()."admin/Shippingreport/page";
			$config['total_rows'] = $data['total_num'];
			$config['per_page'] =25;
			$config['num_links'] =9;
			$data['start']=0;
			$config['full_tag_open'] = "<ul class='pagination'>";
			$config['full_tag_close'] ="</ul>";
			$config['num_tag_open'] = '<li class=\"page-item\">';
			$config['num_tag_close'] = '</li>';
			$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
			$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
			$config['next_tag_open'] = "<li  class=\'page-item\'>";
			$config['next_tagl_close'] = "</li>";
			$config['prev_tag_open'] = "<li class=\'page-item\'>";
			$config['prev_tagl_close'] = "</li>";
			$config['first_tag_open'] = "<li class=\'page-item\'>";
			$config['first_tagl_close'] = "</li>";
			$config['last_tag_open'] = "<li class=\'page-item\'>";
			$config['last_tagl_close'] = "</li>";
			$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
			$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
			$this->pagination->initialize($config);
			if($this->uri->segment(4)!=false){
				$data['start']=$this->uri->segment(4);
			}
			$data['Shippings'] = $this->Reportmodel->GetShipping($data['start'],$config['per_page'],$start_date,$end_date,$order_status);
			if($this->uri->segment(4)){
				$data['page'] = "/".$this->uri->segment(4);
			}else{
				$data['page'] = "";
			}
			$date = new DateTime();
			$data['start_date']=date_format($date,'Y-m-d');
			$data['end_date']=date_format($date,'Y-m-d');
		
			$data['status'] = $this->Ordermodel->GetOrderStatus();
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/shippingreport',$data);
			$this->load->view('admin/footer');
		}else{
			redirect('admin/Shippingreport');
		}	
	}

	public function ExportExcel()
	{
	 
	   $this->load->library('Excel');      
	   $this->excel->setActiveSheetIndex(0);
 
	   $this->excel->getActiveSheet()->setTitle('Shipping report');
 
	   $this->excel->getActiveSheet()->setCellValue('A1', 'Shipping report');
	   $this->excel->getActiveSheet()->setCellValue('A2', 'Shipping Date');
	   $this->excel->getActiveSheet()->setCellValue('B2', 'SHipping Title');
	   $this->excel->getActiveSheet()->setCellValue('C2', 'No. Orders');
	   $this->excel->getActiveSheet()->setCellValue('D2', 'Shipping');
	   
	   
	   $this->excel->getActiveSheet()->mergeCells('A1:D1');
	   
	   $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	   $this->excel->getActiveSheet()->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	   $this->excel->getActiveSheet()->getStyle('B2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	   $this->excel->getActiveSheet()->getStyle('C2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	   $this->excel->getActiveSheet()->getStyle('D2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	  
	   $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
	   $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(24);
	   
		$data =null;
		if($this->input->post('hd_startdate')!=null || $this->input->post('hd_enddate')!=null || $this->input->post('hd_status')!=null){
			$start_date = $this->input->post('hd_startdate');
			$end_status = $this->input->post('hd_enddate');
			$order_status = $this->input->post('hd_status');
			$data=$this->Reportmodel->getShippingToExcel($start_date,$end_status,$order_status);
		}else{
			$data=$this->Reportmodel->getShippingToExcel();
		}
		
		
		$rate="Flat Shipping Rate";
		$info=array();
		foreach ($data as $datas) {
			$item['orderdate']=$datas['orderdate'];
			$item['rate']=$rate;
			$item['no_order']=$datas['no_order'];
			$item['shipping']= number_format($datas['shipping'],2);
			array_push($info,$item);
		}

		 if($info){
		 for($col = ord('A'); $col <= ord('D'); $col++){
			//ตั้งให้เต็ม cell
			$this->excel->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
			 //ตั้งค่า ขนาดอักษร
			$this->excel->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(10);
			 //ตั้งค่า ตำแหน่งอักษร
			$this->excel->getActiveSheet()->getStyle(chr($col))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		 }
		 $this->excel->getActiveSheet()->fromArray($info, null, 'A3');
		 
		 }else{
		  $this->excel->getActiveSheet()->setCellValue('A3', 'ไม่พบข้อมูล');
		  $this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		  $this->excel->getActiveSheet()->mergeCells('A3:D3');
	   }
		 
 
	
	   $filename='shipping-report.xls'; //save our workbook as this file name
	   header('Content-Type: Airluga/vnd.ms-excel'); //mime type
	   header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	   header('Cache-Control: max-age=0'); //no cache
	   $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
	   $objWriter->save('php://output');
	   
	}
}
?>