<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Shippingrate extends CI_Controller {
	function __construct()
	{
		parent::__construct();
   		$this->load->model('admin/Shippingratemodel');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index(){
		$data['total_num']=$this->Shippingratemodel->getShippingrateTotal();
		$config['base_url'] = base_url()."admin/Shippingrate/page";
		$config['total_rows'] = $this->Shippingratemodel->getShippingrateTotal();
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['shippingrates'] = $this->Shippingratemodel->getShippingrate($data['start']);	
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/shippingrate',$data);
		$this->load->view('admin/footer');
	}

	
	public function Form()
	{
		
		$data['countrys'] = $this->Shippingratemodel->getShippingrateCountry();
		$data['action'] = "Create";
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/shippingrate_form',$data);
		$this->load->view('admin/footer');
	}

	public function Create()
	{
		if ($this->ChackValidateForm()) {
			$result = $this->Shippingratemodel->addShippingrate($this->input->post());
			if ($result) {
				redirect('admin/shippingrate');
			}
		}else{
			$data['countrys'] = $this->Shippingratemodel->getShippingrateCountry();
			$data['action'] = "Create";
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/shippingrate_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function ChackValidateForm(){
		$ar=array(
			array(
				'field'=>'txt_shipping_name',
				'label'=>'shipping name',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_shipping_name_en',
				'label'=>'shippingrate name(EN)',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_shippingrate',
				'label'=>'shippingrate',
				'rules'=>'trim|required'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function Delete(){
		$del = $this->Shippingratemodel->Delete($this->input->post('id'));
		if($del){
			$this->load->helper("file");
			$files=glob("uploads/product/".$this->input->post('id')."/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
			  	}
			}
			rmdir("uploads/shippingrate/".$this->input->post('id'));
		}	
	}

	public function DeleteAll(){
		$this->load->helper("file");
		$data=$this->input->post();
		for($n=0;$n<count($data['cb_shippingrate']);$n++){
			$this->Shippingratemodel->Delete($data['cb_shippingrate'][$n]);
			$files=glob("uploads/shippingrate/".$data['cb_shippingrate'][$n]."/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
				}
			}
			rmdir("uploads/shippingrate/".$data['cb_shippingrate'][$n]);
		}
	}
	public function Edit(){
		$data['action'] = "Update";
		$data['countrys'] = $this->Shippingratemodel->getShippingrateCountry();
		$data['shippingrate'] = $this->Shippingratemodel->getShippingratetById($this->uri->segment(4));
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/shippingrate_form',$data);
		$this->load->view('admin/footer');
	}
	public function Update()
	{
		if ($this->ChackValidateForm()) {
			$result = $this->Shippingratemodel->UpdateShippingrate($this->input->post());
			redirect('admin/Shippingrate');
		}else{
			$data['action'] = "Update";
			$data['shippingrates'] = $this->Shippingratemodel->getShippingratetById($this->input->post('hd_id'));
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/shippingrate_form',$data);
			$this->load->view('admin/footer');
		}
	}
}
?>