<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Setting extends CI_Controller {
	function __construct()
   {
      parent::__construct();
      $this->load->model('admin/Settingmodel');
      $this->load->library('form_validation');
      if(!$this->session->userdata('logged_in')){
         redirect('admin/Login');
      }
   }
	public function index(){
      $data['errortext']="";
      $data['info']=$this->Settingmodel->GetSetting();
      $this->load->view('admin/header');
      $this->load->view('admin/menu');
      $this->load->view('admin/setting',$data);
      $this->load->view('admin/footer');
   }

   public function SMTPSetting()
   {
      if($this->ChackValidateForm()){
         if($this->Settingmodel->SaveSetting($this->input->post())){
            redirect('admin/Dashboard');
         }
      }else{
         $data['errortext']="Error : Your information is incorrect. Please try again";
         $data['info']=$this->Settingmodel->GetSetting();
         $this->load->view('admin/header');
         $this->load->view('admin/menu');
         $this->load->view('admin/setting',$data);
         $this->load->view('admin/footer');
      }
   }

   public function ChackValidateForm(){
      $ar=array(
         array(
            'field'=>'txt_mailhost',
            'label'=>'SMTP Hostname',
            'rules'=>'trim|required'
         ),
         array(
            'field'=>'txt_mail',
            'label'=>'SMTP Username',
            'rules'=>'trim|required|valid_email'
         ),
         array(
            'field'=>'txt_password',
            'label'=>'SMTP Password',
            'rules'=>'trim|required'
         ),
         array(
            'field'=>'txt_port',
            'label'=>'SMTP Port',
            'rules'=>'trim|required|numeric'
         )
      );
      
      $this->form_validation->set_rules($ar);
      
      if ($this->form_validation->run() == FALSE){
         return false;
      }else{
         return true;
      }
   }
}
?>