<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Productviewed extends CI_Controller {
	function __construct()
	{
		parent::__construct();
   		$this->load->model('admin/Productmodel');
   		$this->load->model('admin/Settingmodel');
   		$this->load->model('admin/Reportmodel');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index(){
		$data['total_num']=$this->Productmodel->getProductTotal();
		$config['base_url'] = base_url()."admin/Productviewed/page";
		$config['total_rows'] = $data['total_num'];
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li class=\"page-item\">';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li  class=\'page-item\'>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li class=\'page-item\'>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li class=\'page-item\'>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li class=\'page-item\'>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['Products'] = $this->Productmodel->getProduct($data['start'],$config['per_page']);
		$data['totalviewd'] = $this->Productmodel->getProductViewdTotal();
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$date = new DateTime();
		$data['start_date']=date_format($date,'Y-m-d');
		$data['end_date']=date_format($date,'Y-m-d');
		
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/productviewed',$data);
		$this->load->view('admin/footer');
	}

	public function page(){
		$data['total_num']=$this->Productmodel->getProductTotal();
		$config['base_url'] = base_url()."admin/Productviewed/page";
		$config['total_rows'] = $data['total_num'];
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li class=\"page-item\">';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li  class=\'page-item\'>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li class=\'page-item\'>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li class=\'page-item\'>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li class=\'page-item\'>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['Products'] = $this->Productmodel->getProduct($data['start'],$config['per_page']);
		$data['totalviewd'] = $this->Productmodel->getProductViewdTotal();
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$date = new DateTime();
		$data['start_date']=date_format($date,'Y-m-d');
		$data['end_date']=date_format($date,'Y-m-d');
		
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/productviewed',$data);
		$this->load->view('admin/footer');
	}

	public function ExportExcel()
	{
		$this->load->library('Excel');      
      $this->excel->setActiveSheetIndex(0);
      //name the worksheet
      $this->excel->getActiveSheet()->setTitle('Product viewed report');
      //set cell A1 content with some text
      $this->excel->getActiveSheet()->setCellValue('A1', 'Product viewed report');
      $this->excel->getActiveSheet()->setCellValue('A2', 'Product code');
      $this->excel->getActiveSheet()->setCellValue('B2', 'Product name');
      $this->excel->getActiveSheet()->setCellValue('C2', 'Viewed'); 
      $this->excel->getActiveSheet()->setCellValue('D2', 'Percent');
      //merge cell A1 until C1
      $this->excel->getActiveSheet()->mergeCells('A1:D1');
      
      /*$this->cellColor('A1:J1', 'aaaaaa');
      $this->cellColor('A2:J2', 'd1d1d1');*/
      //set aligment to center for that merged cell (A1 to C1)
      $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('B2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('C2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('D2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      //make the font become bold
      $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(10);

      	$result = $this->Reportmodel->getProduct();
      	$totalviewd = $this->Productmodel->getProductViewdTotal();
      	$info = array();
      	foreach ($result as $item) {
      		$percent = ($item['viewd']*100)/$totalviewd->totalviewed;
      		$item['percent'] = number_format($percent,2)."%";
      		array_push($info, $item);	
      	}
      if($info){
         for($col = ord('A'); $col <= ord('D'); $col++){
            //set column dimension
            $this->excel->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
             //change the font size
            $this->excel->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(10);
             
            $this->excel->getActiveSheet()->getStyle(chr($col))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         }
   
         $this->excel->getActiveSheet()->fromArray($info, null, 'A3');
    
         $this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         $this->excel->getActiveSheet()->getStyle('B3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         $this->excel->getActiveSheet()->getStyle('C3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         $this->excel->getActiveSheet()->getStyle('D3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      }else{
         $this->excel->getActiveSheet()->setCellValue('A3', 'ไม่พบข้อมูล');
         $this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         $this->excel->getActiveSheet()->mergeCells('A3:D3');
      }
      $filename='product-view-report.xls'; //save our workbook as this file name
      header('Content-Type: Irin/vnd.ms-excel'); //mime type
      header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
      header('Cache-Control: max-age=0'); //no cache
      //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
      //if you want to save it as .XLSX Excel 2007 format
      $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
      //force user to download the Excel file without writing it to server's HD
      $objWriter->save('php://output');
	}
}
?>