<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {
	function __construct()
	{
		parent::__construct();
   		$this->load->model('admin/Ordermodel');
   		$this->load->model('admin/Settingmodel');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index(){
		$data['total_num']=$this->Ordermodel->getOrderTotal();
		$config['base_url'] = base_url()."admin/Order/page";
		$config['total_rows'] = $this->Ordermodel->getOrderTotal();
		$config['per_page'] =10;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['orders'] = $this->Ordermodel->getOrder($data['start']);
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/order',$data);
		$this->load->view('admin/footer');
	}

	public function page(){
		$data['total_num']=$this->Ordermodel->getOrderTotal();
		$config['base_url'] = base_url()."admin/Order/page";
		$config['total_rows'] = $this->Ordermodel->getOrderTotal();
		$config['per_page'] =10;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['orders'] = $this->Ordermodel->getOrder($data['start']);
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/order',$data);
		$this->load->view('admin/footer');
	}

	public function AddProducts()
	{		
		$result = $this->Ordermodel->CheckOrder($this->input->post('code'),$this->input->post('pid'));
		if ($result) {
			$qty = $result->qty + $this->input->post('qty');
			$result = $this->Ordermodel->AddProductByCode($this->input->post(),$qty);
			if ($result) {
				$this->UpdateOrder($this->input->post('code'));
			}
		}else {
			$orderID = $this->Ordermodel->GetOrderByCode($this->input->post('code'));
			$product = $this->Ordermodel->GetProductById($this->input->post('pid'));
			if($orderID) {
				$result = $this->Ordermodel->AddProduct($this->input->post(),$orderID,$product);
				if ($result) {
					$this->UpdateOrder($this->input->post('code'));
				}
			}
		}
	}

	public function Edit()
	{
		$data['action'] = "Update";		
		$orderNo = $this->uri->segment(4);
		$data['order']=$this->Ordermodel->getInvoice($orderNo);
		$data['billing']=$this->Ordermodel->getBilling($orderNo);
		$data['shipping']=$this->Ordermodel->getShipping($orderNo);
		$data['details']=$this->Ordermodel->getDetail($orderNo);
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		$data['historys'] = $this->Ordermodel->GetOrderHistory($orderNo);
		$data['privilege'] = $this->Ordermodel->GetOrderPrivilege($orderNo);
		$data['products'] = $this->Ordermodel->GetProducts();
		$data['rates'] = $this->Ordermodel->GetShippingRate();
		$data['orderNo'] = $orderNo;
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/order_form',$data);
		$this->load->view('admin/footer');
	}	

	public function UpdateQTY()
	{
		$result = $this->Ordermodel->UpdateQTY($this->input->post());
		if ($result) {
			$this->UpdateOrder($this->input->post('code'));
		}
	}

	public function UpdateOrder($orderNo)
	{
		$orderNo = $orderNo;
		$prices = $this->Ordermodel->GetSumOrder($orderNo);		
		$srate = $this->Ordermodel->GetOrderByCode($orderNo);
		if ($prices) {	
			$subtotal=0;		
			foreach ($prices as $price) {
				$subtotal = $subtotal+($price['qty']*$price['price']);
			}
			$grandtotal = $subtotal+$srate->srate;
			$result = $this->Ordermodel->UpdateOrderByCode($orderNo,$subtotal,$grandtotal);
		}		
	}

	public function EditShipping()
	{			
		$data['action'] = "UpdateShipping";
		$orderNo = $this->uri->segment(4);
		$data['shipping']=$this->Ordermodel->getShipping($orderNo);
		$data['orderNo'] = $orderNo;
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/order_update_shipping',$data);
		$this->load->view('admin/footer');
	}

	public function UpdateShipping()
	{
		if ($this->ChackValidateForm()) {
			$orderNo = $this->uri->segment(4);
			$result = $this->Ordermodel->UpdateShipping($this->input->post(),$orderNo);
			if ($result) {				
				redirect('admin/Order/EditBilling/'.$orderNo);
			}
		}else{
			$data['action'] = "UpdateShipping";
			$orderNo = $this->uri->segment(4);
			$data['shipping']=$this->Ordermodel->getShipping($orderNo);
			$data['orderNo'] = $orderNo;
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/order_update_shipping',$data);
			$this->load->view('admin/footer');
		}
	}

	public function EditBilling()
	{
		$data['action'] = "UpdateBilling";
		$orderNo = $this->uri->segment(4);
		$data['billing']=$this->Ordermodel->getBilling($orderNo);
		$data['orderNo'] = $orderNo;
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/order_update_billing',$data);
		$this->load->view('admin/footer');	
	}

	public function UpdateBilling()
	{
		if ($this->ValidateBilling()) {
			$orderNo = $this->uri->segment(4);
			$result = $this->Ordermodel->UpdateBilling($this->input->post(),$orderNo);
			if ($result) {				
				redirect('admin/Order');
			}
		}else{
			$data['action'] = "UpdateShipping";
			$orderNo = $this->uri->segment(4);
			$data['billing']=$this->Ordermodel->getShipping($orderNo);
			$data['orderNo'] = $orderNo;
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/order_update_billing',$data);
			$this->load->view('admin/footer');
		}
	}

	public function ChangeShipping()
	{
		$sh_rate = $this->Ordermodel->GetShippingRateById($this->input->post('sid'));
		if ($sh_rate) {
			$result = $this->Ordermodel->ChangeShipping($this->input->post('code'),$sh_rate);
			if ($result) {
				$this->UpdateOrder($this->input->post('code'));
			}
		}
	}

	public function Delete(){
		$del = $this->Ordermodel->Delete($this->input->post());
		if ($del) {
			$this->UpdateOrder($this->input->post('code'));
		}
	}

	public function DeleteOrder(){
		$del = $this->Ordermodel->DeleteOder($this->input->post('id'));
	}

	public function DeleteAll(){
		$this->load->helper("file");
		$data=$this->input->post();
		for($n=0;$n<count($data['cb_orders']);$n++){
			$this->Ordermodel->Delete($data['cb_orders'][$n]);
			$files=glob("uploads/order/".$data['cb_orders'][$n]."/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
				}
			}
			rmdir("uploads/order/".$data['cb_orders'][$n]);
		}
	}
	public function View()
	{
		$orderNo = $this->uri->segment(4);
		$data['order']=$this->Ordermodel->getInvoice($orderNo);
		$data['billing']=$this->Ordermodel->getBilling($orderNo);
		$data['shipping']=$this->Ordermodel->getShipping($orderNo);
		$data['details']=$this->Ordermodel->getDetail($orderNo);
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		$data['historys'] = $this->Ordermodel->GetOrderHistory($orderNo);
		$data['privilege'] = $this->Ordermodel->GetOrderPrivilege($orderNo);
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/order_view',$data);
		$this->load->view('admin/footer');
	}
	public function Addhistory(){
		if($this->input->post()){
			$result = $this->Ordermodel->addHistory($this->input->post());
			if($result){
				if($this->input->post('cb_noti')){
					$orderNo = $this->input->post('hd_order_no');
					$info = $this->Settingmodel->GetSetting();					
					$config = Array(
						'protocol' => 'smtp',
						'smtp_host' => $info->hostname,
						'smtp_port' => $info->port,
						'smtp_user' => $info->username, // change it to yours
						'smtp_pass' => $info->password, // change it to yours
						'mailtype' => 'html',
						'charset' => 'utf-8',
						'wordwrap' => TRUE
					);
					$data['order']=$this->Ordermodel->getInvoice($orderNo);
					$data['billing']=$this->Ordermodel->getBilling($orderNo);
					$shipping = $this->Ordermodel->getShipping($orderNo);
					$data['details']=$this->Ordermodel->getDetail($orderNo);
					$data['shipping'] = $shipping;
					$data['order_status'] = $this->Ordermodel->GetOrderStatusById($this->input->post('ddl_order_status'));
					$data['comment'] = $this->input->post('txt_history_comment');
					if ($data['order']->lang == 'EN'){
						$subject="IRIN Update your order status";
						$html = $this->load->view('email/orderstatus_en',$data,true);
					}else{
						$subject="ไอริณ อัตเดตสถานะคำสั่งซื้อของคุณ";
						$html = $this->load->view('email/orderstatus',$data,true);
					}
					$mailto = $shipping->cus_email;

					$this->load->library('email', $config);
					$this->email->set_newline("\r\n");
					$this->email->from($info->username,"IRIN.CO.TH");
					$this->email->to($mailto);
					$this->email->subject($subject);
					$this->email->message($html);
					if($this->email->send()){
						//redirect('Order/Success');
					}else{
						
					}
				}
				redirect("admin/Order/View/".$this->input->post('hd_order_no'));
			}
		}
	}
	public function Invoice()
	{
		$orderNo = $this->uri->segment(4);
		$data['order']=$this->Ordermodel->getInvoice($orderNo);
		$data['billing']=$this->Ordermodel->getBilling($orderNo);
		$data['shipping']=$this->Ordermodel->getShipping($orderNo);
		$data['details']=$this->Ordermodel->getDetail($orderNo);
		$data['privilege'] = $this->Ordermodel->GetOrderPrivilege($orderNo);
		$this->load->view('admin/invoice',$data);
	}
	public function Printshipping()
	{
		$orderNo = $this->uri->segment(4);
		$data['order']=$this->Ordermodel->getInvoice($orderNo);
		$data['billing']=$this->Ordermodel->getBilling($orderNo);
		$data['shipping']=$this->Ordermodel->getShipping($orderNo);
		$data['details']=$this->Ordermodel->getDetail($orderNo);
		$this->load->view('admin/shipping',$data);
	}

	public function Filter()
	{
		if ($this->input->post('txt_orderno')=="" && $this->input->post('txt_customer')=="" 
			&& $this->input->post('ddl_order_status')=="" && $this->input->post('txt_begin_date')=="" 
			&& $this->input->post('txt_end_date')=="")
		{			
			redirect('admin/Order');
		}else{
			$filter = $this->Ordermodel->Filter($this->input->post());
			$data['orders'] = $filter;
			$data['status'] = $this->Ordermodel->GetOrderStatus();
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/order',$data);
			$this->load->view('admin/footer');
		}	
	}
	
	public function ChackValidateForm(){
		$ar=array(
			array(
				'field'=>'txt_name',
				'label'=>'Shipping first name',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_lastname',
				'label'=>'Shipping lastname',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_email',
				'label'=>'Shipping Email',
				'rules'=>'trim|required|valid_email'
			),
			array(
				'field'=>'txt_address',
				'label'=>'Shipping address',
				'rules'=>'trim|required|min_length[10]'
			),
			array(
				'field'=>'txt_contry',
				'label'=>'Shipping contry',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_province',
				'label'=>'Shipping province',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_city',
				'label'=>'Shipping city',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_subdist',
				'label'=>'Shipping subdistrict',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_pos',
				'label'=>'Shipping zipcode',
				'rules'=>'trim|required|alpha_numeric|min_length[5]'
			),
			array(
				'field'=>'txt_tel',
				'label'=>'Shipping tel',
				'rules'=>'trim|required|min_length[9]|max_length[16]'
			),
			array(
				'field'=>'txt_line',
				'label'=>'Line ID',
				'rules'=>'trim|required'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function ValidateBilling()
	{
		$ar=array(
			array(
				'field'=>'txt_bi_name',
				'label'=>'Billing first name',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_bi_lastname',
				'label'=>'Billing lastname',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_bi_address',
				'label'=>'Billing address',
				'rules'=>'trim|required|min_length[10]'
			),
			array(
				'field'=>'txt_bi_contry',
				'label'=>'Billing contry',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_bi_province',
				'label'=>'Billing province',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_bi_city',
				'label'=>'Billing city',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_bi_subdist',
				'label'=>'Billing subdistrict',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_bi_pos',
				'label'=>'Billing zipcode',
				'rules'=>'trim|required|min_length[5]'
			),
			array(
				'field'=>'txt_bi_tel',
				'label'=>'Billing tel',
				'rules'=>'trim|required|min_length[9]|max_length[16]'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}
}
?>