<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/Dashboardmodel');
		$this->load->model('admin/Ordermodel');
		if(!$this->session->userdata('logged_in')){
		   redirect('admin/Login');
		}
	}
	public function index()
	{
		$data['orders'] = $this->Ordermodel->getOrder(0,10);
		$data['daily_total']=$this->Ordermodel->GetDailySale();
		$data['month_total']=$this->Ordermodel->GetMonthSale();
		$data['year_total']=$this->Ordermodel->GetYearSale();
		$data['count_cus'] = $this->Dashboardmodel->GetCountCustomer();
		$data['count_order'] = $this->Dashboardmodel->GetCountOrder();
		$data['count_shipping'] = $this->Dashboardmodel->GetCountShipping();
		$data['count_complete'] = $this->Dashboardmodel->GetCountComplete();
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/dashboard',$data);
		$this->load->view('admin/footer');
	}
}
