<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customerreport extends CI_Controller {
	function __construct()
	{
		parent::__construct();
   		$this->load->model('admin/Ordermodel');
   		$this->load->model('admin/Settingmodel');
   		$this->load->model('admin/Reportmodel');
   		$this->load->helper('text');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index(){
		$data['total_num']=$this->Reportmodel->GetCustomerTotal();
		$config['base_url'] = base_url()."admin/Customerreport/page";
		$config['total_rows'] = $data['total_num'];
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li class=\"page-item\">';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li  class=\'page-item\'>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li class=\'page-item\'>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li class=\'page-item\'>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li class=\'page-item\'>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['Customers'] = $this->Reportmodel->GetCustomer($data['start'],$config['per_page']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$date = new DateTime();
		$data['start_date']=date_format($date,'Y-m-d');
		$data['end_date']=date_format($date,'Y-m-d');
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customerreport',$data);
		$this->load->view('admin/footer');
	}

	public function page(){
		$data['total_num']=$this->Reportmodel->GetCustomerTotal();
		$config['base_url'] = base_url()."admin/Customerreport/page";
		$config['total_rows'] = $data['total_num'];
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li class=\"page-item\">';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li  class=\'page-item\'>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li class=\'page-item\'>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li class=\'page-item\'>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li class=\'page-item\'>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['Customers'] = $this->Reportmodel->GetCustomer($data['start'],$config['per_page']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$date = new DateTime();
		$data['start_date']=date_format($date,'Y-m-d');
		$data['end_date']=date_format($date,'Y-m-d');
		$data['status'] = $this->Ordermodel->GetOrderStatus();
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customerreport',$data);
		$this->load->view('admin/footer');
	}

	public function Filter(){
		if($this->input->post()){
			$start_date = null;
			if($this->input->post('txt_start_date')!=0){
				$start_date = $this->input->post('txt_start_date');
			}
			$end_date = null;
			if($this->input->post('txt_end_date')!=0){
				$end_date = $this->input->post('txt_end_date');
			}
			$order_status = null;
			if($this->input->post('ddl_order_status')!="0"){
				$order_status = $this->input->post('ddl_order_status');
				$data['ddl_order_status'] =  $this->input->post('ddl_order_status');
			}
			$data['total_num']=$this->Reportmodel->GetCustomerTotal($start_date,$end_date,$order_status);
			$config['base_url'] = base_url()."admin/Customerreport/page";
			$config['total_rows'] = $data['total_num'];
			$config['per_page'] =25;
			$config['num_links'] =9;
			$data['start']=0;
			$config['full_tag_open'] = "<ul class='pagination'>";
			$config['full_tag_close'] ="</ul>";
			$config['num_tag_open'] = '<li class=\"page-item\">';
			$config['num_tag_close'] = '</li>';
			$config['cur_tag_open'] = "<li class='page-item disabled active'><a class=\"page-link\" href='#'>";
			$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
			$config['next_tag_open'] = "<li  class=\'page-item\'>";
			$config['next_tagl_close'] = "</li>";
			$config['prev_tag_open'] = "<li class=\'page-item\'>";
			$config['prev_tagl_close'] = "</li>";
			$config['first_tag_open'] = "<li class=\'page-item\'>";
			$config['first_tagl_close'] = "</li>";
			$config['last_tag_open'] = "<li class=\'page-item\'>";
			$config['last_tagl_close'] = "</li>";
			$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
			$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
			$this->pagination->initialize($config);
			if($this->uri->segment(4)!=false){
				$data['start']=$this->uri->segment(4);
			}
			$data['Customers'] = $this->Reportmodel->GetCustomer($data['start'],$config['per_page'],$start_date,$end_date,$order_status);
			if($this->uri->segment(4)){
				$data['page'] = "/".$this->uri->segment(4);
			}else{
				$data['page'] = "";
			}
			$date = new DateTime();
			$data['start_date']=date_format($date,'Y-m-d');
			$data['end_date']=date_format($date,'Y-m-d');
		
			$data['status'] = $this->Ordermodel->GetOrderStatus();
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/customerreport',$data);
			$this->load->view('admin/footer');
		}else{
			redirect('admin/Customerreport');
		}
		
	}

	public function Customerorder()
	{
		$result = $this->Reportmodel->getCustomerOder($this->uri->segment(4));
		$arr = array();
		if ($result) {
			foreach ($result as $item) {
				$order = $this->Reportmodel->getOderDetail($item['id']);
				foreach ($order as $item) {
					$info['product_id']=$item['product_id'];
					$info['product_name']=$item['product_name'];
					$info['qty']=$item['qty'];
					array_push($arr, $info);
				}				
			}
		}
		$data['result'] = $arr;
		$data['products'] = $this->Reportmodel->getProduct();
		$data['customer'] = $this->Reportmodel->getCustomerById($this->uri->segment(4));
		$data['lastorderdate'] = $this->Reportmodel->getCustomerLastOder($this->uri->segment(4));
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customerorder',$data);
		$this->load->view('admin/footer');		
		//print_r($arr);
	}

	public function ExportExcel()
   	{
	
      $this->load->library('Excel');      
      $this->excel->setActiveSheetIndex(0);

	  $this->excel->getActiveSheet()->setTitle('Customer report');

	  $this->excel->getActiveSheet()->setCellValue('A1', 'Customer report');
	  $this->excel->getActiveSheet()->setCellValue('A2', 'Customer Name');
      $this->excel->getActiveSheet()->setCellValue('B2', 'E-Mail');
      $this->excel->getActiveSheet()->setCellValue('C2', 'No.Order');
	  $this->excel->getActiveSheet()->setCellValue('D2', 'No.Product'); 
	  $this->excel->getActiveSheet()->setCellValue('E2', 'Total'); 
	  	  
	  $this->excel->getActiveSheet()->mergeCells('A1:E1');
	  
	  $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('B2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('C2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('D2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('E2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
     
      $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
	  $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(24);	  
	
		if($this->input->post('hd_startdate')!=null || $this->input->post('hd_enddate')!=null || $this->input->post('hd_status')!=null){
			$start_date = $this->input->post('hd_startdate');
			$end_status = $this->input->post('hd_enddate');
			$order_status = $this->input->post('hd_status');
			$data=$this->Reportmodel->getCustomerToExcel($start_date,$end_status,$order_status);
		}else{
			$data=$this->Reportmodel->getCustomerToExcel();
		}		
		
		$info=array();
		foreach ($data as $datas) {
			$item['name']=$datas['name']." ".$datas['surname'];
			$item['email']=$datas['email'];
			$item['total_order']=$datas['total_order'];
			$item['total_qty']= $datas['total_qty'];
			$item['totalsumary']= number_format($datas['totalsumary'],2);
			array_push($info,$item);
		}
	  
		if(isset($info)){
			for($col = ord('A'); $col <= ord('E'); $col++){
			   //ตั้งให้เต็ม cell
			   $this->excel->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
				//ตั้งค่า ขนาดอักษร
			   $this->excel->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(10);
				//ตั้งค่า ตำแหน่งอักษร
			   $this->excel->getActiveSheet()->getStyle(chr($col))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::VERTICAL_CENTER);
			}
			$this->excel->getActiveSheet()->fromArray($info, null, 'A3');
		

		}else{
         	$this->excel->getActiveSheet()->setCellValue('A3', 'ไม่พบข้อมูล');
         	$this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         	$this->excel->getActiveSheet()->mergeCells('A3:E3');
      	}   
      $filename='customer-report.xls'; //save our workbook as this file name
      header('Content-Type: Airluga/vnd.ms-excel'); //mime type
      header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
      header('Cache-Control: max-age=0'); //no cache
      $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
	  $objWriter->save('php://output');	  
   }
}
?>