<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/Customermodel');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index()
	{
		$data['total_num']=$this->Customermodel->getCustomerTotal();
		$config['base_url'] = base_url()."admin/Customer/page";
		$config['total_rows'] = $this->Customermodel->getCustomerTotal();
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['customers'] = $this->Customermodel->getCustomer($data['start']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customer',$data);
		$this->load->view('admin/footer');
	}

	public function page()
	{
		$data['total_num']=$this->Customermodel->getCustomerTotal();
		$config['base_url'] = base_url()."admin/Customer/page";
		$config['total_rows'] = $this->Customermodel->getCustomerTotal();
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['customers'] = $this->Customermodel->getCustomer($data['start']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customer',$data);
		$this->load->view('admin/footer');
	}

	public function Form()
	{
		$data['action'] = "Create";
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customer_form',$data);
		$this->load->view('admin/footer');
	}

	public function Create()
	{
		if ($this->ChackValidateForm()) {
			$result = $this->Customermodel->addCustomer($this->input->post());
			if ($result) {
				redirect('admin/Customer');
			}
		}else{
			$data['action'] = "Create";
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/customer_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Edit()
	{
		$data['action'] = "Update";
		$data['customer'] = $this->Customermodel->getCustomerById($this->uri->segment(4));
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/customer_form',$data);
		$this->load->view('admin/footer');
	}

	public function Update()
	{
		if ($this->ChackValidateFormUpdate()) {
			$result = $this->Customermodel->updateCustomer($this->input->post());
			if ($result) {
				redirect('admin/Customer');
			}
		}else{
			$data['action'] = "Update";
			$data['customer'] = $this->Customermodel->getCustomerById($this->input->post('hd_id'));
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/customer_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Delete(){
		$del = $this->Customermodel->Delete($this->input->post('id'));
		if($del){
			$this->load->helper("file");
			$files=glob("uploads/customer/".$this->input->post('id')."/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
			  	}
			}
			rmdir("uploads/customer/".$this->input->post('id'));
		}	
	}

	public function DeleteAll(){
		$this->load->helper("file");
		$data=$this->input->post();
		for($n=0;$n<count($data['cb_cus']);$n++){
			$this->Customermodel->Delete($data['cb_cus'][$n]);
			$files=glob("uploads/customer/".$data['cb_cus'][$n]."/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
				}
			}
			rmdir("uploads/customer/".$data['cb_cus'][$n]);
		}
	}

	public function ChackValidateForm(){
		$ar=array(
			array(
				'field'=>'txt_account',
				'label'=>'Account ID',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_password',
				'label'=>'Password',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_name',
				'label'=>'Name',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_surname',
				'label'=>'Surname',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_phone',
				'label'=>'Phone number',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_email',
				'label'=>'Email',
				'rules'=>'trim|required|valid_email'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function ChackValidateFormUpdate(){
		$ar=array(
			array(
				'field'=>'txt_name',
				'label'=>'Name',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_surname',
				'label'=>'Surname',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_phone',
				'label'=>'Phone number',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_email',
				'label'=>'Email',
				'rules'=>'trim|required|valid_email'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function ExportExcel()
   	{
	
      $this->load->library('Excel');      
      $this->excel->setActiveSheetIndex(0);

	  $this->excel->getActiveSheet()->setTitle('Irin customer');

	  $this->excel->getActiveSheet()->setCellValue('A1', 'Irin customer list');
	  $this->excel->getActiveSheet()->setCellValue('A2', 'Customer Name');
      $this->excel->getActiveSheet()->setCellValue('B2', 'Phone');
      $this->excel->getActiveSheet()->setCellValue('C2', 'Email');
	  $this->excel->getActiveSheet()->setCellValue('D2', 'Register date'); 
	  $this->excel->getActiveSheet()->setCellValue('E2', 'Last login'); 
	  	  
	  $this->excel->getActiveSheet()->mergeCells('A1:E1');
	  
	  $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('B2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('C2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('D2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
      $this->excel->getActiveSheet()->getStyle('E2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
     
      $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
	  $this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(16);
	  $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
	  $this->excel->getActiveSheet()->getStyle('B2')->getFont()->setBold(true);
	  $this->excel->getActiveSheet()->getStyle('C2')->getFont()->setBold(true);
	  $this->excel->getActiveSheet()->getStyle('D2')->getFont()->setBold(true);
	  $this->excel->getActiveSheet()->getStyle('E2')->getFont()->setBold(true);  
	
		$result=$this->Customermodel->getCustomerToExcel();		
		$info=array();
		foreach ($result as $customer) {
			$item['name']=$customer['name'];
			$item['phone']=$customer['phone'];
			$item['email']=$customer['email'];
			$item['create_date']=$customer['create_date'];
			if ($customer['last_login']) {
				$item['last_login']= $customer['last_login'];
			}else{
				$item['last_login']= "0000-00-00 00:00:00";
			}			
			array_push($info,$item);
		}
	  
		if(isset($info)){
			for($col = ord('A'); $col <= ord('E'); $col++){
			   //ตั้งให้เต็ม cell
			   $this->excel->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
				//ตั้งค่า ขนาดอักษร
			   $this->excel->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(10);
				//ตั้งค่า ตำแหน่งอักษร
			   $this->excel->getActiveSheet()->getStyle(chr($col))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::VERTICAL_CENTER);
			   $this->excel->getActiveSheet()->getStyle(chr($col))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
			}
			$this->excel->getActiveSheet()->fromArray($info, null, 'A3');			
		}else{
         	$this->excel->getActiveSheet()->setCellValue('A3', 'ไม่พบข้อมูล');
         	$this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
         	$this->excel->getActiveSheet()->mergeCells('A3:E3');
      	}   
      $filename='irin customer.xls'; //save our workbook as this file name
      header('Content-Type: Irin/vnd.ms-excel'); //mime type
      header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
      header('Cache-Control: max-age=0'); //no cache
      $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
	  $objWriter->save('php://output');	  
   }
}