<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Article extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/Articlemodel');
   		$this->load->library('form_validation');
   		$this->load->library('pagination');
	   	if(!$this->session->userdata('logged_in')){
		   	redirect('admin/Login');
		}
	}

	public function index()
	{
		$data['total_num']=$this->Articlemodel->getArticleTotal();
		$config['base_url'] = base_url()."admin/Article/page";
		$config['total_rows'] = $this->Articlemodel->getArticleTotal();
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['articles'] = $this->Articlemodel->getArticle($data['start']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/article',$data);
		$this->load->view('admin/footer');
	}

	public function page()
	{
		$data['total_num']=$this->Articlemodel->getArticleTotal();
		$config['base_url'] = base_url()."admin/Article/page";
		$config['total_rows'] = $this->Articlemodel->getArticleTotal();
		$config['per_page'] =25;
		$config['num_links'] =9;
		$data['start']=0;
		$config['full_tag_open'] = "<ul class='pagination'>";
		$config['full_tag_close'] ="</ul>";
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] = "<li>";
		$config['next_tagl_close'] = "</li>";
		$config['prev_tag_open'] = "<li>";
		$config['prev_tagl_close'] = "</li>";
		$config['first_tag_open'] = "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] = "<li>";
		$config['last_tagl_close'] = "</li>";
		$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
		$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
		$this->pagination->initialize($config);
		if($this->uri->segment(4)!=false){
			$data['start']=$this->uri->segment(4);
		}
		$data['articles'] = $this->Articlemodel->getArticle($data['start']);
		if($this->uri->segment(4)){
			$data['page'] = "/".$this->uri->segment(4);
		}else{
			$data['page'] = "";
		}
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/article',$data);
		$this->load->view('admin/footer');
	}

	public function Filter()
	{
		if($this->input->post('txt_title')=="" && $this->input->post('ddl_recommend')==""){			
			redirect('admin/Article');
		}else{
			$data['total_num']=$this->Articlemodel->FilterTotal($this->input->post());
			$config['base_url'] = base_url()."admin/Article/page";
			$config['total_rows'] = $this->Articlemodel->FilterTotal($this->input->post());
			$config['per_page'] =25;
			$config['num_links'] =9;
			$data['start']=0;
			$config['full_tag_open'] = "<ul class='pagination'>";
			$config['full_tag_close'] ="</ul>";
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
			$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
			$config['next_tag_open'] = "<li>";
			$config['next_tagl_close'] = "</li>";
			$config['prev_tag_open'] = "<li>";
			$config['prev_tagl_close'] = "</li>";
			$config['first_tag_open'] = "<li>";
			$config['first_tagl_close'] = "</li>";
			$config['last_tag_open'] = "<li>";
			$config['last_tagl_close'] = "</li>";
			$config['first_link'] = "<span aria-hidden=\"true\">&laquo;</span>";
			$config['last_link'] = "<span aria-hidden=\"true\">&raquo;</span>";
			$this->pagination->initialize($config);
			if($this->uri->segment(4)!=false){
				$data['start']=$this->uri->segment(4);
			}
			$data['articles'] = $this->Articlemodel->Filter($data['start'],$this->input->post());
			if($this->uri->segment(4)){
				$data['page'] = "/".$this->uri->segment(4);
			}else{
				$data['page'] = "";
			}
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/article',$data);
			$this->load->view('admin/footer');		
		}
	}

	public function Form()
	{
		$data['action'] = "Create";
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/article_form',$data);
		$this->load->view('admin/footer');
	}

	public function Create()
	{
		if ($this->ChackValidateForm()) {
			$result = $this->Articlemodel->addArticle($this->input->post());
			if ($result) {
				redirect('admin/Article');
			}
		}else{
			$data['action'] = "Create";
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/article_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Edit()
	{
		$data['action'] = "Update";
		$data['article'] = $this->Articlemodel->getArticleById($this->uri->segment(4));
		$this->load->view('admin/header');
		$this->load->view('admin/menu');
		$this->load->view('admin/article_form',$data);
		$this->load->view('admin/footer');
	}

	public function Update()
	{
		if ($this->ChackValidateForm()) {
			$result = $this->Articlemodel->updateArticle($this->input->post());
			if ($result) {
				redirect('admin/Article');
			}
		}else{
			$data['action'] = "Update";
			$data['article'] = $this->Articlemodel->getArticleById($this->input->post('hd_id'));
			$this->load->view('admin/header');
			$this->load->view('admin/menu');
			$this->load->view('admin/article_form',$data);
			$this->load->view('admin/footer');
		}
	}

	public function Delete(){
		$del = $this->Articlemodel->Delete($this->input->post('id'));
		if($del){
			$this->load->helper("file");
			$files=glob("uploads/article/".$this->input->post('id')."/*");
			$banners=glob("uploads/article/".$this->input->post('id')."/banner/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
			  	}
			}
			foreach($banners as $banner){ 
				if(is_file($banner)){
					unlink($banner);
			  	}
			}
			rmdir("uploads/article/".$this->input->post('id')."/banner");
			rmdir("uploads/article/".$this->input->post('id'));
		}	
	}
	public function Recommended(){
		$data = $this->Articlemodel->Recommended($this->input->post('tbl'),$this->input->post('id'),$this->input->post('status'));		
	}
	public function DeleteAll(){
		$this->load->helper("file");
		$data=$this->input->post();
		for($n=0;$n<count($data['cb_articles']);$n++){
			$this->Articlemodel->Delete($data['cb_articles'][$n]);
			$files=glob("uploads/article/".$data['cb_articles'][$n]."/*");
			$banners=glob("uploads/article/".$data['cb_articles'][$n]."/banner/*");
			foreach($files as $file){ 
				if(is_file($file)){
					unlink($file);
				}
			}
			foreach($banners as $banner){ 
				if(is_file($banner)){
					unlink($banner);
			  	}
			}
			rmdir("uploads/article/".$data['cb_articles'][$n]."/banner");
			rmdir("uploads/article/".$data['cb_articles'][$n]);
		}
	}

	public function ChackValidateForm(){
		$ar=array(
			array(
				'field'=>'txt_title',
				'label'=>'Article title',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_shortdesc',
				'label'=>'Short description',
				'rules'=>'trim|required'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}

	public function ChackValidateFormUpdate(){
		$ar=array(
			array(
				'field'=>'txt_name',
				'label'=>'Name',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_surname',
				'label'=>'Surname',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_phone',
				'label'=>'Phone number',
				'rules'=>'trim|required'
			),
			array(
				'field'=>'txt_email',
				'label'=>'Email',
				'rules'=>'trim|required|valid_email'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}
}