<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Promotion extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->model('Promotionmodel');
		$this->load->model('Tagsmodel');
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$this->lang->load('Header', 'english');
				$this->lang->load('promotion', 'english');
				$this->lang->load('footer', 'english');
			}else{
				$this->lang->load('Header', 'thai');
				$this->lang->load('promotion', 'thai');
				$this->lang->load('footer', 'thai');
			}
		}else{
			$this->session->set_userdata('lang',"TH");
			$this->lang->load('Header', 'thai');
			$this->lang->load('promotion', 'thai');
			$this->lang->load('footer', 'thai');
		}
	}

	public function index()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}		
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
			$hdata['txt_and']=$this->lang->line('txt_and');
			$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$data['txt_undata']=$this->lang->line('txt_undata');
		$data['txt_promotion_title']=$this->lang->line('txt_promotion_title');
		$data['txt_read_more']=$this->lang->line('txt_read_more');
		$result = $this->Promotionmodel->GetPromotion();
		$arr=array();
		$lang = $this->session->userdata('lang');
		if ($result) {
			foreach ($result as $item) {
				$item['tags']=explode(",", $item['tags']);
				if ($lang=="EN") {
					$item['title']=$item['title_en'];
					$item['short_desc']=$item['short_desc_en'];
				}else{
					$item['title']=$item['title'];
					$item['short_desc']=$item['short_desc'];
				}
				array_push($arr, $item);
			}					
		}
		$data['promotions'] = $arr;
		$data['countinfo'] = $this->Promotionmodel->CountPromotion();
		$this->load->view('common/header',$hdata);
		$this->load->view('promotion',$data);
		$this->load->view('common/footer',$fdata);
	}

	public function Description()
	{
		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
			$hdata['txt_and']=$this->lang->line('txt_and');
			$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$data['txt_recomm_pro']=$this->lang->line('txt_recomm_pro');
		$data['txt_undata']=$this->lang->line('txt_undata');
		$result = $this->Promotionmodel->GetPromotionById($this->uri->segment(3));
		$hdata['meta_og_url'] = current_url();
		$hdata['meta_og_title'] = $result->title;
		$hdata['meta_og_desc'] = $result->short_desc;
		$hdata['meta_og_image'] = base_url($result->img);

		$arr = array();
		$arr_info = array();
		$artrelate=$this->Promotionmodel->getRecommended($result->id);
		if ($artrelate) {
			foreach ($artrelate as $info) {
				$info['tags']=explode(",", $info['tags']);
				array_push($arr_info, $info);
			}
		}
		$lang = $this->session->userdata('lang');
		$desc = array();
		$meta_title="";
		$meta_key="";
		$meta_desc="";
		if ($result) {
			if ($lang=="EN") {
				$data['title']=$result->title_en;
				$data['short_desc']=$result->short_desc_en;
				$data['desc']=$result->desc_en;
				$meta_title =$result->title_en;
				$meta_key =$result->meta_key;
				$meta_desc =$result->short_desc_en;
			}else{
				$data['title']=$result->title;
				$data['short_desc']=$result->short_desc;
				$data['desc']=$result->desc;
				$meta_title =$result->title;
				$meta_key =$result->meta_key;
				$meta_desc =$result->short_desc;
			}
		}
		$hdata['page_title'] = $meta_title;
		$hdata['meta_desc'] = $meta_desc;
		$hdata['meta_keyword'] = $meta_key;
		$data['desc'] = $result;
		$data['rel'] = $arr_info;
		$this->load->view('common/header',$hdata);
		$this->load->view('promotion_desc',$data);
		$this->load->view('common/footer',$fdata);
	}

	public function Tags()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');
		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
			$hdata['txt_and']=$this->lang->line('txt_and');
			$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$data['basecon'] = "Promotion";
		$result = $this->Tagsmodel->GetInfoByTags($this->uri->segment(3),'tbl_promotion');
		$arr=array();
		$lang = $this->session->userdata('lang');
		if ($result) {
			foreach ($result as $item) {
				$item['tags']=explode(",", $item['tags']);
				if ($lang=="EN") {
					$item['title']=$item['title_en'];
					$item['short_desc']=$item['short_desc_en'];
				}else{
					$item['title']=$item['title'];
					$item['short_desc']=$item['short_desc'];
				}
				array_push($arr, $item);
			}					
		}
		$data['infotags'] = $arr;
		$this->load->view('common/header',$hdata);
		$this->load->view('tags',$data);
		$this->load->view('common/footer',$fdata);
	}
}