<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->model('Customermodel');
		if(!$this->session->userdata('cus_logged_in')){
		   redirect('Signin');
		}
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$this->lang->load('Header', 'english');
				$this->lang->load('footer', 'english');
			}else{
				$this->lang->load('Header', 'thai');
				$this->lang->load('footer', 'thai');
			}
		}else{
			$this->session->set_userdata('lang',"TH");
			$this->lang->load('Header', 'thai');
			$this->lang->load('footer', 'thai');
		}
	}

	public function index()
	{
		$session_account = $this->session->userdata('cus_logged_in');
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_line']=$this->lang->line('txt_line');
$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');

		$hdata['txt_address']=$this->lang->line('txt_address');
		$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
		$hdata['txt_shipping']=$this->lang->line('txt_shipping');
		$hdata['txt_billing']=$this->lang->line('txt_billing');
		$hdata['txt_fname']=$this->lang->line('txt_fname');
		$hdata['txt_lname']=$this->lang->line('txt_lname');
		$hdata['txt_email']=$this->lang->line('txt_email');
		$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
		$hdata['txt_country']=$this->lang->line('txt_country');
		$hdata['txt_province']=$this->lang->line('txt_province');
		$hdata['txt_city']=$this->lang->line('txt_city');
		$hdata['txt_district']=$this->lang->line('txt_district');
		$hdata['txt_postcode']=$this->lang->line('txt_postcode');		
		$hdata['txt_copy']=$this->lang->line('txt_copy');
		$hdata['txt_progress']=$this->lang->line('txt_progress');
			

		$hdata['txt_account']=$this->lang->line('txt_account');
		$hdata['txt_account_manag']=$this->lang->line('txt_account_manag');
		$hdata['txt_profile']=$this->lang->line('txt_profile');
		$hdata['txt_save']=$this->lang->line('txt_save');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$hdata['txt_opass']=$this->lang->line('txt_opass');
		$hdata['txt_npass']=$this->lang->line('txt_npass');		
		$data['info'] = $this->Customermodel->GetProfile($session_account['id']);
		$data['active']="active";
		$this->load->view('common/header',$hdata);
		$this->load->view('profile',$data);
		$this->load->view('common/footer',$fdata);
	}

	public function editProfile()
	{
		if ($this->ChackValidateForm()) {
			$result = $this->Customermodel->Update($this->input->post());
			if($result){
				redirect('Profile');
			}
		}else{
			$session_account = $this->session->userdata('cus_logged_in');
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			if ($this->session->userdata('lang')=="TH") {
				$hdata['page_title'] = META_TITLE_TH;
				$hdata['meta_desc'] = META_DESC_TH;
				$hdata['meta_keyword'] = META_KEYWORD_TH;
				$hdata['meta_og_title'] = META_TITLE_TH;
				$hdata['meta_og_desc'] = META_DESC_TH;
			}else{		
				$hdata['page_title'] = META_TITLE_EN;
				$hdata['meta_desc'] = META_DESC_EN;
				$hdata['meta_keyword'] = META_KEYWORD_EN;		
				$hdata['meta_og_title'] = META_TITLE_EN;
				$hdata['meta_og_desc'] = META_DESC_EN;
			}			
			$hdata['meta_og_url'] = current_url();			
			$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

			$hdata['txt_product']=$this->lang->line('txt_product');
			$hdata['txt_article']=$this->lang->line('txt_article');
			$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
			$hdata['txt_promotion']=$this->lang->line('txt_promotion');
			$hdata['txt_review']=$this->lang->line('txt_review');
			$hdata['txt_about']=$this->lang->line('txt_about');
			$hdata['txt_contact']=$this->lang->line('txt_contact');
			$hdata['txt_login']=$this->lang->line('txt_login');
			$hdata['txt_sign']=$this->lang->line('txt_sign');
			$hdata['txt_edit']=$this->lang->line('txt_edit');
			$hdata['txt_change']=$this->lang->line('txt_change');
			$hdata['txt_logout']=$this->lang->line('txt_logout');
			$hdata['txt_policy']=$this->lang->line('txt_policy');
			$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
			$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
			$hdata['txt_confirm']=$this->lang->line('txt_confirm');
			$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
			$hdata['txt_ok']=$this->lang->line('txt_ok');
			$hdata['txt_cancle']=$this->lang->line('txt_cancle');
			$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
			$hdata['txt_forget']=$this->lang->line('txt_forget');
			$hdata['txt_mail']=$this->lang->line('txt_mail');
			$hdata['txt_pass']=$this->lang->line('txt_pass');
			$hdata['txt_keep']=$this->lang->line('txt_keep');
			$hdata['txt_name']=$this->lang->line('txt_name');
			$hdata['txt_conpass']=$this->lang->line('txt_conpass');
			$hdata['txt_conterms']=$this->lang->line('txt_conterms');
			$hdata['txt_terms']=$this->lang->line('txt_terms');
			$hdata['txt_mycart']=$this->lang->line('txt_mycart');
			$hdata['txt_item']=$this->lang->line('txt_item');
			$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
			$hdata['txt_shprate']=$this->lang->line('txt_shprate');
			$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
			$hdata['txt_contshop']=$this->lang->line('txt_contshop');
			$hdata['txt_checkout']=$this->lang->line('txt_checkout');
			$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
			$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
			$fdata['txt_product']=$this->lang->line('txt_product');
			$fdata['txt_info']=$this->lang->line('txt_info');
			$fdata['txt_office']=$this->lang->line('txt_office');
			$fdata['txt_new_product']=$this->lang->line('txt_new_product');
			$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
			$fdata['txt_about']=$this->lang->line('txt_about');
			$fdata['txt_contact']=$this->lang->line('txt_contact');
			$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
			$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
			$fdata['txt_policy']=$this->lang->line('txt_policy');
			$hdata['txt_line']=$this->lang->line('txt_line');
			$hdata['txt_phone']=$this->lang->line('txt_phone');
			$hdata['txt_his']=$this->lang->line('txt_his');			
			$hdata['txt_address']=$this->lang->line('txt_address');
			$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
			$hdata['txt_shipping']=$this->lang->line('txt_shipping');
			$hdata['txt_billing']=$this->lang->line('txt_billing');
			$hdata['txt_fname']=$this->lang->line('txt_fname');
			$hdata['txt_lname']=$this->lang->line('txt_lname');
			$hdata['txt_email']=$this->lang->line('txt_email');
			$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
			$hdata['txt_country']=$this->lang->line('txt_country');
			$hdata['txt_province']=$this->lang->line('txt_province');
			$hdata['txt_city']=$this->lang->line('txt_city');
			$hdata['txt_district']=$this->lang->line('txt_district');
			$hdata['txt_postcode']=$this->lang->line('txt_postcode');			
			$hdata['txt_copy']=$this->lang->line('txt_copy');
			$hdata['txt_progress']=$this->lang->line('txt_progress');
				

			$hdata['txt_account']=$this->lang->line('txt_account');
			$hdata['txt_account_manag']=$this->lang->line('txt_account_manag');
			$hdata['txt_profile']=$this->lang->line('txt_profile');
			$hdata['txt_save']=$this->lang->line('txt_save');
			$hdata['txt_his']=$this->lang->line('txt_his');
			$hdata['txt_opass']=$this->lang->line('txt_opass');
			$hdata['txt_npass']=$this->lang->line('txt_npass');
			$data['info'] = $this->Customermodel->GetProfile($session_account['id']);
			$data['active']="active";
			$this->load->view('common/header',$hdata);
			$this->load->view('profile',$data);
			$this->load->view('common/footer',$fdata);
		}
	}

	public function editPassword()
	{
		$session_account = $this->session->userdata('cus_logged_in');
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_line']=$this->lang->line('txt_line');
$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');		
		$hdata['txt_address']=$this->lang->line('txt_address');
		$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
		$hdata['txt_shipping']=$this->lang->line('txt_shipping');
		$hdata['txt_billing']=$this->lang->line('txt_billing');
		$hdata['txt_fname']=$this->lang->line('txt_fname');
		$hdata['txt_lname']=$this->lang->line('txt_lname');
		$hdata['txt_email']=$this->lang->line('txt_email');
		$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
		$hdata['txt_country']=$this->lang->line('txt_country');
		$hdata['txt_province']=$this->lang->line('txt_province');
		$hdata['txt_city']=$this->lang->line('txt_city');
		$hdata['txt_district']=$this->lang->line('txt_district');
		$hdata['txt_postcode']=$this->lang->line('txt_postcode');		
		$hdata['txt_copy']=$this->lang->line('txt_copy');
		$hdata['txt_progress']=$this->lang->line('txt_progress');
			

		$hdata['txt_account']=$this->lang->line('txt_account');
		$hdata['txt_account_manag']=$this->lang->line('txt_account_manag');
		$hdata['txt_profile']=$this->lang->line('txt_profile');
		$hdata['txt_save']=$this->lang->line('txt_save');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$hdata['txt_opass']=$this->lang->line('txt_opass');
		$hdata['txt_npass']=$this->lang->line('txt_npass');
		$data['info'] = $this->Customermodel->GetProfile($session_account['id']);
		$data['actives']="active";
		$this->load->view('common/header',$hdata);
		$this->load->view('profile',$data);
		$this->load->view('common/footer',$fdata);
	}

	public function updatePassword()
	{
		$result = $this->Customermodel->CheckPassword($this->input->post('hd_id'),$this->input->post('txt_opass'));
		$npass = $this->input->post('txt_npass');
		$cpass = $this->input->post('txt_cpass');
		if ($result) {
			if ($npass === $cpass) {				
				$password = $this->Customermodel->UpdatePassword($this->input->post());
				if($password){
					redirect('Profile');
				}else{
					redirect('Profile');
				}
			}else{
				$session_account = $this->session->userdata('cus_logged_in');
				$hdata['page_title'] = META_TITLE_TH;
				$hdata['meta_desc'] = META_DESC_TH;
				$hdata['meta_keyword'] = META_KEYWORD_TH;
				if ($this->session->userdata('lang')=="TH") {
					$hdata['page_title'] = META_TITLE_TH;
					$hdata['meta_desc'] = META_DESC_TH;
					$hdata['meta_keyword'] = META_KEYWORD_TH;
					$hdata['meta_og_title'] = META_TITLE_TH;
					$hdata['meta_og_desc'] = META_DESC_TH;
				}else{		
					$hdata['page_title'] = META_TITLE_EN;
					$hdata['meta_desc'] = META_DESC_EN;
					$hdata['meta_keyword'] = META_KEYWORD_EN;		
					$hdata['meta_og_title'] = META_TITLE_EN;
					$hdata['meta_og_desc'] = META_DESC_EN;
				}
				$hdata['meta_og_url'] = current_url();				
				$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

				$hdata['txt_product']=$this->lang->line('txt_product');
				$hdata['txt_article']=$this->lang->line('txt_article');
				$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
				$hdata['txt_promotion']=$this->lang->line('txt_promotion');
				$hdata['txt_review']=$this->lang->line('txt_review');
				$hdata['txt_about']=$this->lang->line('txt_about');
				$hdata['txt_contact']=$this->lang->line('txt_contact');
				$hdata['txt_login']=$this->lang->line('txt_login');
				$hdata['txt_sign']=$this->lang->line('txt_sign');
				$hdata['txt_edit']=$this->lang->line('txt_edit');
				$hdata['txt_change']=$this->lang->line('txt_change');
				$hdata['txt_logout']=$this->lang->line('txt_logout');
				$hdata['txt_policy']=$this->lang->line('txt_policy');
				$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
				$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
				$hdata['txt_confirm']=$this->lang->line('txt_confirm');
				$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
				$hdata['txt_ok']=$this->lang->line('txt_ok');
				$hdata['txt_cancle']=$this->lang->line('txt_cancle');
				$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
				$hdata['txt_forget']=$this->lang->line('txt_forget');
				$hdata['txt_mail']=$this->lang->line('txt_mail');
				$hdata['txt_pass']=$this->lang->line('txt_pass');
				$hdata['txt_keep']=$this->lang->line('txt_keep');
				$hdata['txt_name']=$this->lang->line('txt_name');
				$hdata['txt_conpass']=$this->lang->line('txt_conpass');
				$hdata['txt_conterms']=$this->lang->line('txt_conterms');
				$hdata['txt_terms']=$this->lang->line('txt_terms');
				$hdata['txt_mycart']=$this->lang->line('txt_mycart');
				$hdata['txt_item']=$this->lang->line('txt_item');
				$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
				$hdata['txt_shprate']=$this->lang->line('txt_shprate');
				$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
				$hdata['txt_contshop']=$this->lang->line('txt_contshop');
				$hdata['txt_checkout']=$this->lang->line('txt_checkout');
				$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
				$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');		
				$hdata['txt_address']=$this->lang->line('txt_address');
				$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
				$hdata['txt_shipping']=$this->lang->line('txt_shipping');
				$hdata['txt_billing']=$this->lang->line('txt_billing');
				$hdata['txt_fname']=$this->lang->line('txt_fname');
				$hdata['txt_lname']=$this->lang->line('txt_lname');
				$hdata['txt_email']=$this->lang->line('txt_email');
				$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
				$hdata['txt_country']=$this->lang->line('txt_country');
				$hdata['txt_province']=$this->lang->line('txt_province');
				$hdata['txt_city']=$this->lang->line('txt_city');
				$hdata['txt_district']=$this->lang->line('txt_district');
				$hdata['txt_postcode']=$this->lang->line('txt_postcode');		
				$hdata['txt_copy']=$this->lang->line('txt_copy');
				$hdata['txt_progress']=$this->lang->line('txt_progress');
					

				$hdata['txt_account']=$this->lang->line('txt_account');
				$hdata['txt_account_manag']=$this->lang->line('txt_account_manag');
				$hdata['txt_profile']=$this->lang->line('txt_profile');
				$hdata['txt_save']=$this->lang->line('txt_save');
				$hdata['txt_his']=$this->lang->line('txt_his');
				$hdata['txt_opass']=$this->lang->line('txt_opass');
				$hdata['txt_npass']=$this->lang->line('txt_npass');
				$fdata['txt_product']=$this->lang->line('txt_product');
				$fdata['txt_info']=$this->lang->line('txt_info');
				$fdata['txt_office']=$this->lang->line('txt_office');
				$fdata['txt_new_product']=$this->lang->line('txt_new_product');
				$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
				$fdata['txt_about']=$this->lang->line('txt_about');
				$fdata['txt_contact']=$this->lang->line('txt_contact');
				$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
				$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
				$fdata['txt_policy']=$this->lang->line('txt_policy');
				$hdata['txt_line']=$this->lang->line('txt_line');
				$hdata['txt_phone']=$this->lang->line('txt_phone');
				$hdata['txt_his']=$this->lang->line('txt_his');
				$data['info'] = $this->Customermodel->GetProfile($session_account['id']);
				$data['actives']="active";
				$data['matchpass']="รหัสผ่านใหม่ไม่ตรงกัน";
				$this->load->view('common/header',$hdata);
				$this->load->view('profile',$data);
				$this->load->view('common/footer',$fdata);
			}
		}else{
			$session_account = $this->session->userdata('cus_logged_in');
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			if ($this->session->userdata('lang')=="TH") {
				$hdata['page_title'] = META_TITLE_TH;
				$hdata['meta_desc'] = META_DESC_TH;
				$hdata['meta_keyword'] = META_KEYWORD_TH;
				$hdata['meta_og_title'] = META_TITLE_TH;
				$hdata['meta_og_desc'] = META_DESC_TH;
			}else{		
				$hdata['page_title'] = META_TITLE_EN;
				$hdata['meta_desc'] = META_DESC_EN;
				$hdata['meta_keyword'] = META_KEYWORD_EN;		
				$hdata['meta_og_title'] = META_TITLE_EN;
				$hdata['meta_og_desc'] = META_DESC_EN;
			}			
			$hdata['meta_og_url'] = current_url();			
			$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

			$hdata['txt_product']=$this->lang->line('txt_product');
			$hdata['txt_article']=$this->lang->line('txt_article');
			$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
			$hdata['txt_promotion']=$this->lang->line('txt_promotion');
			$hdata['txt_review']=$this->lang->line('txt_review');
			$hdata['txt_about']=$this->lang->line('txt_about');
			$hdata['txt_contact']=$this->lang->line('txt_contact');
			$hdata['txt_login']=$this->lang->line('txt_login');
			$hdata['txt_sign']=$this->lang->line('txt_sign');
			$hdata['txt_edit']=$this->lang->line('txt_edit');
			$hdata['txt_change']=$this->lang->line('txt_change');
			$hdata['txt_logout']=$this->lang->line('txt_logout');
			$hdata['txt_policy']=$this->lang->line('txt_policy');
			$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
			$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
			$hdata['txt_and']=$this->lang->line('txt_and');
			$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
			$hdata['txt_confirm']=$this->lang->line('txt_confirm');
			$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
			$hdata['txt_ok']=$this->lang->line('txt_ok');
			$hdata['txt_cancle']=$this->lang->line('txt_cancle');
			$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
			$hdata['txt_forget']=$this->lang->line('txt_forget');
			$hdata['txt_mail']=$this->lang->line('txt_mail');
			$hdata['txt_pass']=$this->lang->line('txt_pass');
			$hdata['txt_keep']=$this->lang->line('txt_keep');
			$hdata['txt_name']=$this->lang->line('txt_name');
			$hdata['txt_conpass']=$this->lang->line('txt_conpass');
			$hdata['txt_conterms']=$this->lang->line('txt_conterms');
			$hdata['txt_terms']=$this->lang->line('txt_terms');
			$hdata['txt_mycart']=$this->lang->line('txt_mycart');
			$hdata['txt_item']=$this->lang->line('txt_item');
			$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
			$hdata['txt_shprate']=$this->lang->line('txt_shprate');
			$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
			$hdata['txt_contshop']=$this->lang->line('txt_contshop');
			$hdata['txt_checkout']=$this->lang->line('txt_checkout');
			$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
			$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
			$fdata['txt_product']=$this->lang->line('txt_product');
			$fdata['txt_info']=$this->lang->line('txt_info');
			$fdata['txt_office']=$this->lang->line('txt_office');
			$fdata['txt_new_product']=$this->lang->line('txt_new_product');
			$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
			$fdata['txt_about']=$this->lang->line('txt_about');
			$fdata['txt_contact']=$this->lang->line('txt_contact');
			$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
			$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
			$fdata['txt_policy']=$this->lang->line('txt_policy');
			$hdata['txt_line']=$this->lang->line('txt_line');
			$hdata['txt_phone']=$this->lang->line('txt_phone');
			$hdata['txt_his']=$this->lang->line('txt_his');

			$hdata['txt_address']=$this->lang->line('txt_address');
			$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
			$hdata['txt_shipping']=$this->lang->line('txt_shipping');
			$hdata['txt_billing']=$this->lang->line('txt_billing');
			$hdata['txt_fname']=$this->lang->line('txt_fname');
			$hdata['txt_lname']=$this->lang->line('txt_lname');
			$hdata['txt_email']=$this->lang->line('txt_email');
			$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
			$hdata['txt_country']=$this->lang->line('txt_country');
			$hdata['txt_province']=$this->lang->line('txt_province');
			$hdata['txt_city']=$this->lang->line('txt_city');
			$hdata['txt_district']=$this->lang->line('txt_district');
			$hdata['txt_postcode']=$this->lang->line('txt_postcode');			
			$hdata['txt_copy']=$this->lang->line('txt_copy');
			$hdata['txt_progress']=$this->lang->line('txt_progress');
							
			$hdata['txt_account']=$this->lang->line('txt_account');
			$hdata['txt_account_manag']=$this->lang->line('txt_account_manag');
			$hdata['txt_profile']=$this->lang->line('txt_profile');
			$hdata['txt_save']=$this->lang->line('txt_save');
			$hdata['txt_his']=$this->lang->line('txt_his');
			$hdata['txt_opass']=$this->lang->line('txt_opass');
			$hdata['txt_npass']=$this->lang->line('txt_npass');
			$data['info'] = $this->Customermodel->GetProfile($session_account['id']);
			$data['actives']="active";
			$data['failpass']="รหัสผ่านเก่าไม่ตรงกัน";
			$this->load->view('common/header',$hdata);
			$this->load->view('profile',$data);
			$this->load->view('common/footer',$fdata);
		}		
	}

	public function ChackValidateForm(){
		$ar=array(
			array(
				'field'=>'txt_name',
				'label'=>'Shipping first name',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_lastname',
				'label'=>'Shipping lastname',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_email',
				'label'=>'Shipping Email',
				'rules'=>'trim|required|valid_email'
			),
			array(
				'field'=>'txt_address',
				'label'=>'Shipping address',
				'rules'=>'trim|required|min_length[10]'
			),
			array(
				'field'=>'txt_contry',
				'label'=>'Shipping contry',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_province',
				'label'=>'Shipping province',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_city',
				'label'=>'Shipping city',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_subdist',
				'label'=>'Shipping subdistrict',
				'rules'=>'trim|required|min_length[2]'
			),
			array(
				'field'=>'txt_pos',
				'label'=>'Shipping zipcode',
				'rules'=>'trim|required|alpha_numeric|min_length[5]'
			),
			array(
				'field'=>'txt_tel',
				'label'=>'Shipping tel',
				'rules'=>'trim|required|min_length[9]|max_length[16]'
			),
			array(
				'field'=>'txt_line',
				'label'=>'Line ID',
				'rules'=>'trim|required'
			)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}
}