<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->library('cart');
		$this->load->library('form_validation');
		$this->load->helper('text');
		$this->load->model('Productmodel');
		$this->load->model('Ordermodel');
		$this->load->model('Homemodel');
		$this->load->model('admin/Settingmodel');
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$this->lang->load('Header', 'english');
				$this->lang->load('footer', 'english');
			}else{
				$this->lang->load('Header', 'thai');
				$this->lang->load('footer', 'thai');
			}
		}else{
			$this->session->set_userdata('lang',"TH");
			$this->lang->load('Header', 'thai');
			$this->lang->load('footer', 'thai');
		}
	}

	public function index()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');

		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');

		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');
		
		$carts = $this->cart->contents();
		if($carts){
			$data['carts'] = $carts;
			$this->load->view('common/header',$hdata);
			$this->load->view('order_message',$data);
			$this->load->view('common/wherecream');
			$this->load->view('common/footer',$fdata);
		}else{
			redirect('Product');
		}
	}
	public function History()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}		
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');

		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');

		$hdata['txt_account_manag']=$this->lang->line('txt_account_manag');
		$hdata['txt_profile']=$this->lang->line('txt_profile');
		$hdata['txt_save']=$this->lang->line('txt_save');

		$hdata['txt_date']=$this->lang->line('txt_date');
		$hdata['txt_order_no']=$this->lang->line('txt_order_no');
		$hdata['txt_order_status']=$this->lang->line('txt_order_status');
		$hdata['txt_total']=$this->lang->line('txt_total');
		$hdata['txt_action']=$this->lang->line('txt_action');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		$data['wherebuies'] = $this->Homemodel->GetWherebuy();
		if($this->session->userdata('cus_logged_in'))
        {
          	$session_data = $this->session->userdata('cus_logged_in');
			$data['Historys'] = $this->Ordermodel->GetOrdersHistory($session_data['id']);
			$this->load->view('common/header',$hdata);
			$this->load->view('order_history',$data);
			$this->load->view('common/wherecream');
			$this->load->view('common/footer',$fdata);
		}
		
	}
	
	public function Callback(){
        $this->load->library('payment');
        $this->load->model('Ordermodel');
        $this->payment->log();
        $this->payment->parse_result();

        // Return 400 Bad request on result invalid
        if (!$this->payment->is_result_valid()){
            header('x-payment: invalid');
            return false;
        }

        $order_id = $this->payment->get_order_id();
        $order_no = $this->payment->get_order_no();
        $this->payment->save_result();

        if ($this->payment->is_paid()){
            $this->Ordermodel->markAsPaid($order_id);
            //$this->ExportConfirmPDF($order_no);
			//$this->mailThank($order_no,$order_id);
			//$this->SendmailNotification($order_no);
        } else if ($this->payment->is_pending()){
            $this->Ordermodel->markAsPending($order_id);
        }
	}
	public function Result(){
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$this->load->library('payment');
        $this->load->model('Ordermodel');
        $this->payment->log();
        $this->payment->parse_result();
        if (!$this->payment->is_result_valid()){
            $this->Fail();
        }
        $order_id = $this->payment->get_order_id();
        $order_no = $this->payment->get_order_no();
        $this->payment->save_result();
        if ($this->payment->is_paid()){
            $this->Ordermodel->markAsPaid($order_id);
			$this->cart->destroy();
			$this->Emailthankyou($order_no);
            $this->Success();
        } else if ($this->payment->is_pending()){
            $this->Ordermodel->markAsPending($order_id);
            $this->cart->destroy();
            $this->Emailthankyou($order_no);
            $this->Success();
        } else {
			$this->Fail();
        }
	}
	public function Success()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');

		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$data['header_message'] = "Thank you for your order";
				$data['message'] = "Thank you for order. You order has been received and will be delivered. You can check the email for your tracking number."; 
			}else{
				$data['header_message'] = "ขอขอบคุณสำหรับการสั่งซื้อของคุณ";
				$data['message'] = "ขอบคุณสำหรับคำสั่งซื้อ ทางเราได้รับคำสั่งซื้อของคุณแล้วและจะจัดส่งสินค้าให้คุณ คุณสามารถตรวจสอบสถานะคำสั่งซื้อได้ผ่านอีเมลของคุณ"; 
			}
		}else{
			$data['header_message'] = "ขอขอบคุณสำหรับการสั่งซื้อของคุณ";
			$data['message'] = "ขอบคุณสำหรับคำสั่งซื้อ ทางเราได้รับคำสั่งซื้อของคุณแล้วและจะจัดส่งสินค้าให้คุณ คุณสามารถตรวจสอบสถานะคำสั่งซื้อได้ผ่านอีเมลของคุณ"; 
		}
		

		$this->load->view('common/header',$hdata);
		$this->load->view('order_message',$data);
		$this->load->view('common/wherecream');
		$this->load->view('common/footer',$fdata);
	}
	public function Fail()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');

		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$data['header_message'] = "Your Order Fail.";
				$data['message'] = "Sorry, an error occurred while processing your order. Please try again.."; 
			}else{
				$data['header_message'] = "เกิดข้อผิดพลาดขณะทำการสั่งซื้อสินค้าของคุณ";
				$data['message'] = "ขอโทษค่ะ เกิดข้อผิดพลาดขณะทำการสั่งซื้อสินค้าของคุณ กรุณาลองใหม่อีกครั้งค่ะ"; 
			}
		}else{
			$data['header_message'] = "เกิดข้อผิดพลาดขณะทำการสั่งซื้อสินค้าของคุณ";
			$data['message'] = "ขอโทษค่ะ เกิดข้อผิดพลาดขณะทำการสั่งซื้อสินค้าของคุณ กรุณาลองใหม่อีกครั้งค่ะ"; 
		}
		
		$this->load->view('common/header',$hdata);
		$this->load->view('order_message',$data);
		$this->load->view('common/wherecream');
		$this->load->view('common/footer',$fdata);
	}
	public function Emailthankyou($orderNo)
	{
		$info = $this->Settingmodel->GetSetting();		
		$config = Array(
			'protocol' => 'smtp',
			'smtp_host' => $info->hostname,
			'smtp_port' => $info->port,
			'smtp_user' => $info->username, // change it to yours
			'smtp_pass' => $info->password, // change it to yours
			'mailtype' => 'html',
			'charset' => 'utf-8',
			'wordwrap' => TRUE
		);
		$data['order']=$this->Ordermodel->getInvoice($orderNo);
		$data['billing']=$this->Ordermodel->getBilling($orderNo);
		$shipping = $this->Ordermodel->getShipping($orderNo);
		$data['details']=$this->Ordermodel->getDetail($orderNo);
		$data['privilege'] = $this->Ordermodel->GetOrderPrivilege($orderNo);
		$data['shipping'] = $shipping;
		if ($this->session->userdata('lang')=="EN"){			
			$subject="IRIN Thank You For Your Order";
			$html = $this->load->view('email/emailorder_en',$data,true);
		}else{
			$subject="ไอริณ ขอขอบคุณสำหรับรายการสั่งซื้อของคุณ";
			$html = $this->load->view('email/emailorder',$data,true);
		}
		$mailto = $shipping->cus_email;

		$this->load->library('email', $config);
		$this->email->set_newline("\r\n");
		$this->email->from($info->username,"IRIN.CO.TH");
		$this->email->to($mailto);
		$this->email->subject($subject);
		$this->email->message($html);
		if($this->email->send()){
			//redirect('Order/Success');
		}else{
			
		}
	}
	public function Emailorder()
	{
	}
}