<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class History extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->library('cart');
   		$this->load->model('Ordermodel');
   		$this->load->model('Productmodel');
   		$this->load->model('admin/Shippingratemodel');
   		if(!$this->session->userdata('cus_logged_in')){
		   	redirect('Home');
		}
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$this->lang->load('Header', 'english');
				$this->lang->load('contact', 'english');
				$this->lang->load('footer', 'english');
			}else{
				$this->lang->load('Header', 'thai');
				$this->lang->load('contact', 'thai');
				$this->lang->load('footer', 'thai');
			}
		}else{
			$this->session->set_userdata('lang',"TH");
			$this->lang->load('Header', 'thai');
			$this->lang->load('contact', 'thai');
			$this->lang->load('footer', 'thai');
		}
	}
	public function Order()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$data['txt_address']=$this->lang->line('txt_address');
		$data['txt_myaddress']=$this->lang->line('txt_myaddress');
		$data['txt_shipping']=$this->lang->line('txt_shipping');
		$data['txt_billing']=$this->lang->line('txt_billing');
		$data['txt_fname']=$this->lang->line('txt_fname');
		$data['txt_lname']=$this->lang->line('txt_lname');
		$data['txt_email']=$this->lang->line('txt_email');
		$data['txt_address_fill']=$this->lang->line('txt_address_fill');
		$data['txt_country']=$this->lang->line('txt_country');
		$data['txt_province']=$this->lang->line('txt_province');
		$data['txt_city']=$this->lang->line('txt_city');
		$data['txt_district']=$this->lang->line('txt_district');
		$data['txt_postcode']=$this->lang->line('txt_postcode');
		$data['txt_phone']=$this->lang->line('txt_phone');
		$data['txt_copy']=$this->lang->line('txt_copy');
		$data['txt_progress']=$this->lang->line('txt_progress');
		
		$data['txt_account']=$this->lang->line('txt_account');
		$data['txt_account_manag']=$this->lang->line('txt_account_manag');
		$data['txt_profile']=$this->lang->line('txt_profile');
		$data['txt_save']=$this->lang->line('txt_save');
		$data['txt_his']=$this->lang->line('txt_his');
		$data['txt_opass']=$this->lang->line('txt_opass');
		$data['txt_npass']=$this->lang->line('txt_npass');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$orderNo = $this->uri->segment(3);
		if($this->Ordermodel->orderVerified($orderNo)){
			$data['order']=$this->Ordermodel->getInvoice($orderNo);
			$data['billing']=$this->Ordermodel->getBilling($orderNo);
			$shipping = $this->Ordermodel->getShipping($orderNo);
			$data['details']=$this->Ordermodel->getDetail($orderNo);
			$data['shipping'] = $shipping;
			$this->load->view('history_order',$data);
		}
	}
	public function Reorder()
	{
		$orderNo = $this->uri->segment(3);
		if($this->Ordermodel->orderVerified($orderNo)){
			$products=$this->Ordermodel->getDetail($orderNo);
			foreach ($products as $item) {
				$product_id=$item['product_id'];
				$product_qty=$item['qty'];
				$product = $this->Productmodel->GetProductById($product_id);
				$shippingrate = $this->Shippingratemodel->getCurrentShippingrate();
				$shipping = 32.00;
				if($product->weight > 200){
					$shipping = (($product->weight * $product_qty)/100) * $shippingrate->shipping_rate;
				}
				
				if($product){
					$newItem = true;
					$carts = $this->cart->contents();
					foreach($carts as $item){
						if($item['id']===$product->id){
							$bag = array('rowid'=>$item['rowid'],'qty'=>$item['qty']+$product_qty,'shipping'=>$item['shipping']+$shipping);
							$this->cart->update($bag);
							$newItem = false;
						}
					}

					if($newItem){
						$data = array(
				        'id'      => $product->id,
				        'qty'     => $product_qty,
				        'price'   => $product->price ,
				        'name'    => $product->name,
				        'name_en'    => $product->name,
				        'weight'    => $product->weight,
				        'shipping'    => $shipping,
				        'image'    => base_url($product->img),
						);
						$rowid=$this->cart->insert($data);
					}
				}

			}
			redirect('Cart/Address');
		}
	}
}
?>