<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cart extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->library('cart');
		$this->load->library('form_validation');
		$this->load->model('Productmodel');
		$this->load->model('Ordermodel');
		$this->load->model('Homemodel');
		$this->load->model('admin/Shippingratemodel');
		$this->load->model('admin/Privilegemodel');
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$this->lang->load('Header', 'english');
				$this->lang->load('footer', 'english');
			}else{
				$this->lang->load('Header', 'thai');
				$this->lang->load('footer', 'thai');
			}
		}else{
			$this->session->set_userdata('lang',"TH");
			$this->lang->load('Header', 'thai');
			$this->lang->load('footer', 'thai');
		}
	}

	public function index()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');

		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');

		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$data['txt_item']=$this->lang->line('txt_item');
		$data['txt_price']=$this->lang->line('txt_price');
		$data['text_shippingrate']=$this->lang->line('text_shippingrate');

		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$shippingrate = $this->Shippingratemodel->getShippingrateActive();
		$arrShipping = array();
		if($shippingrate){
			foreach($shippingrate as $item){
				if($this->session->userdata('lang')){
					if($this->session->userdata('lang')=="EN"){
						$item['shipping_name_text'] = $item['shipping_name_en'];
					}else{
						$item['shipping_name_text'] = $item['shipping_name'];
					}
				}else{
					$item['shipping_name_text'] = $item['shipping_name'];
				}
				array_push($arrShipping,$item);
			}
		}
		$data['shippings'] = $arrShipping;
		$data['wherebuies'] = $this->Homemodel->GetWherebuy();
		$carts = $this->cart->contents();
		if($carts){
			$data['carts'] = $carts;
			$this->load->view('common/header',$hdata);
			$this->load->view('cart',$data);
			$this->load->view('common/wherecream');
			$this->load->view('common/footer',$fdata);
		}else{
			redirect('Product');
		}
	}
	public function Address()
	{
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');

		$hdata['txt_address']=$this->lang->line('txt_address');
		$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
		$hdata['txt_shipping']=$this->lang->line('txt_shipping');
		$hdata['txt_billing']=$this->lang->line('txt_billing');
		$hdata['txt_fname']=$this->lang->line('txt_fname');
		$hdata['txt_lname']=$this->lang->line('txt_lname');
		$hdata['txt_email']=$this->lang->line('txt_email');
		$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
		$hdata['txt_country']=$this->lang->line('txt_country');
		$hdata['txt_province']=$this->lang->line('txt_province');
		$hdata['txt_city']=$this->lang->line('txt_city');
		$hdata['txt_district']=$this->lang->line('txt_district');
		$hdata['txt_postcode']=$this->lang->line('txt_postcode');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_copy']=$this->lang->line('txt_copy');
		$hdata['txt_progress']=$this->lang->line('txt_progress');
		$data['txt_previlege_head']=$this->lang->line('txt_previlege_head');
		$data['txt_previlege_text']=$this->lang->line('txt_previlege_text');
		$data['text_shippingrate']=$this->lang->line('text_shippingrate');
		$data['txt_previlege'] = $this->lang->line('txt_previlege');
		$data['txt_condition_privilege'] = $this->lang->line('txt_condition_privilege');
		$data['txt_privilege_additional'] = $this->lang->line('txt_privilege_additional');
		$data['txt_accept'] = $this->lang->line('txt_accept');
		$data['shipping'] = 0;
		$shippingrate = $this->Shippingratemodel->getShippingrateActive();
		$arrShipping = array();
		if($shippingrate){
			foreach($shippingrate as $item){
				if($this->session->userdata('lang')){
					if($this->session->userdata('lang')=="EN"){
						$item['shipping_name_text'] = $item['shipping_name_en'];
					}else{
						$item['shipping_name_text'] = $item['shipping_name'];
					}
				}else{
					$item['shipping_name_text'] = $item['shipping_name'];
				}
				array_push($arrShipping,$item);
			}
		}
		$data['shippings'] = $arrShipping;

		//Privilege --------------------------------------------------------------////////
		$privileges = $this->Privilegemodel->getPrivilegeActive();
		$arrPrivilege = array();
		if($privileges){
			foreach($privileges as $privile){
				if($this->session->userdata('lang')=="EN"){
					$privile['privilege_name_text'] = $privile['title_en'];
					
				}else{
					$privile['privilege_name_text'] = $privile['title'];
					
				}
				array_push($arrPrivilege,$privile);
			}
		}
		$data['privileges'] = $arrPrivilege;

		$data['account'] ="";
		$this->load->model('Customermodel');
		if($this->session->userdata('cus_logged_in')){
		   $session_account = $this->session->userdata('cus_logged_in');
		   $data['info'] = $this->Customermodel->GetProfile($session_account['id']);
		}
		$carts = $this->cart->contents();
		$data['wherebuies'] = $this->Homemodel->GetWherebuy();
		if($carts){
			$data['carts'] = $carts;
			$this->load->view('common/header',$hdata);
			$this->load->view('address',$data);
			$this->load->view('common/wherecream');
			$this->load->view('common/footer',$fdata);
		}else{
			redirect('Product');
		}
	}
	public function Checkout()
	{
		$carts = $this->cart->contents();
		if($this->input->post()&&$carts){
			if($this->ChackValidateForm()){
				$carts = $this->cart->contents();
				$shipping = $this->Shippingratemodel->getShippingratetById($this->input->post('rb_shipping'));
				$order = $this->Ordermodel->Order($this->input->post(),$carts,$shipping);
				//$this->cart->destroy();
				if($order){
					$this->Confirmation($order->order_no);
				}
				
			}else{
				$hdata['page_title'] = META_TITLE_TH;
				$hdata['meta_desc'] = META_DESC_TH;
				$hdata['meta_keyword'] = META_KEYWORD_TH;
				if ($this->session->userdata('lang')=="TH") {
					$hdata['page_title'] = META_TITLE_TH;
					$hdata['meta_desc'] = META_DESC_TH;
					$hdata['meta_keyword'] = META_KEYWORD_TH;
					$hdata['meta_og_title'] = META_TITLE_TH;
					$hdata['meta_og_desc'] = META_DESC_TH;
				}else{		
					$hdata['page_title'] = META_TITLE_EN;
					$hdata['meta_desc'] = META_DESC_EN;
					$hdata['meta_keyword'] = META_KEYWORD_EN;		
					$hdata['meta_og_title'] = META_TITLE_EN;
					$hdata['meta_og_desc'] = META_DESC_EN;
				}				
				$hdata['meta_og_url'] = current_url();				
				$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

				$hdata['txt_product']=$this->lang->line('txt_product');
				$hdata['txt_article']=$this->lang->line('txt_article');
				$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
				$hdata['txt_promotion']=$this->lang->line('txt_promotion');
				$hdata['txt_review']=$this->lang->line('txt_review');
				$hdata['txt_about']=$this->lang->line('txt_about');
				$hdata['txt_contact']=$this->lang->line('txt_contact');
				$hdata['txt_login']=$this->lang->line('txt_login');
				$hdata['txt_sign']=$this->lang->line('txt_sign');
				$hdata['txt_edit']=$this->lang->line('txt_edit');
				$hdata['txt_change']=$this->lang->line('txt_change');
				$hdata['txt_logout']=$this->lang->line('txt_logout');
				$hdata['txt_policy']=$this->lang->line('txt_policy');
				$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
				$hdata['txt_and']=$this->lang->line('txt_and');
				$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
				$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
				$fdata['txt_help_order']=$this->lang->line('txt_help_order');
				$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
				$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
				$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
				$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
				$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		
				$hdata['txt_confirm']=$this->lang->line('txt_confirm');
				$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
				$hdata['txt_ok']=$this->lang->line('txt_ok');
				$hdata['txt_cancle']=$this->lang->line('txt_cancle');
				$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
				$hdata['txt_forget']=$this->lang->line('txt_forget');
				$hdata['txt_mail']=$this->lang->line('txt_mail');
				$hdata['txt_pass']=$this->lang->line('txt_pass');
				$hdata['txt_keep']=$this->lang->line('txt_keep');
				$hdata['txt_name']=$this->lang->line('txt_name');
				$hdata['txt_conpass']=$this->lang->line('txt_conpass');
				$hdata['txt_conterms']=$this->lang->line('txt_conterms');
				$hdata['txt_terms']=$this->lang->line('txt_terms');
				$fdata['txt_product']=$this->lang->line('txt_product');
				$fdata['txt_info']=$this->lang->line('txt_info');
				$fdata['txt_office']=$this->lang->line('txt_office');
				$fdata['txt_new_product']=$this->lang->line('txt_new_product');
				$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
				$fdata['txt_about']=$this->lang->line('txt_about');
				$fdata['txt_contact']=$this->lang->line('txt_contact');
				$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
				$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
				$fdata['txt_policy']=$this->lang->line('txt_policy');
				$hdata['txt_mycart']=$this->lang->line('txt_mycart');
				$hdata['txt_item']=$this->lang->line('txt_item');
				$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
				$hdata['txt_shprate']=$this->lang->line('txt_shprate');
				$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
				$hdata['txt_contshop']=$this->lang->line('txt_contshop');
				$hdata['txt_checkout']=$this->lang->line('txt_checkout');
				$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
				$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
				$hdata['txt_line']=$this->lang->line('txt_line');
				$hdata['txt_phone']=$this->lang->line('txt_phone');
				$hdata['txt_his']=$this->lang->line('txt_his');
				$hdata['txt_address']=$this->lang->line('txt_address');
				$hdata['txt_myaddress']=$this->lang->line('txt_myaddress');
				$hdata['txt_shipping']=$this->lang->line('txt_shipping');
				$hdata['txt_billing']=$this->lang->line('txt_billing');
				$hdata['txt_fname']=$this->lang->line('txt_fname');
				$hdata['txt_lname']=$this->lang->line('txt_lname');
				$hdata['txt_email']=$this->lang->line('txt_email');
				$hdata['txt_address_fill']=$this->lang->line('txt_address_fill');
				$hdata['txt_country']=$this->lang->line('txt_country');
				$hdata['txt_province']=$this->lang->line('txt_province');
				$hdata['txt_city']=$this->lang->line('txt_city');
				$hdata['txt_district']=$this->lang->line('txt_district');
				$hdata['txt_postcode']=$this->lang->line('txt_postcode');
				$hdata['txt_phone']=$this->lang->line('txt_phone');
				$hdata['txt_his']=$this->lang->line('txt_his');
				$hdata['txt_line']=$this->lang->line('txt_line');
				$hdata['txt_copy']=$this->lang->line('txt_copy');
				$hdata['txt_progress']=$this->lang->line('txt_progress');
				$data['txt_item']=$this->lang->line('txt_item');
				$data['txt_price']=$this->lang->line('txt_price');
				$data['text_shippingrate']=$this->lang->line('text_shippingrate');
				$data['txt_previlege_head']=$this->lang->line('txt_previlege_head');
				$data['txt_previlege_text']=$this->lang->line('txt_previlege_text');
				$data['text_shippingrate']=$this->lang->line('text_shippingrate');
				$data['txt_previlege'] = $this->lang->line('txt_previlege');
				$data['txt_condition_privilege'] = $this->lang->line('txt_condition_privilege');
				$data['txt_privilege_additional'] = $this->lang->line('txt_privilege_additional');
				$data['txt_accept'] = $this->lang->line('txt_accept');
				$data['shipping'] = 0;
				$shippingrate = $this->Shippingratemodel->getShippingrateActive();
				$arrShipping = array();
				if($shippingrate){
					foreach($shippingrate as $item){
						if($this->session->userdata('lang')){
							if($this->session->userdata('lang')=="EN"){
								$item['shipping_name_text'] = $item['shipping_name_en'];
							}else{
								$item['shipping_name_text'] = $item['shipping_name'];
							}
						}else{
							$item['shipping_name_text'] = $item['shipping_name'];
						}
						array_push($arrShipping,$item);
					}
				}
				$data['shippings'] = $arrShipping;

				//Privilege --------------------------------------------------------------////////
				$privileges = $this->Privilegemodel->getPrivilegeActive();
				$arrPrivilege = array();
				if($privileges){
					foreach($privileges as $privile){
						if($this->session->userdata('lang')=="EN"){
							$privile['privilege_name_text'] = $privile['title_en'];
							
						}else{
							$privile['privilege_name_text'] = $privile['title'];
							
						}
						array_push($arrPrivilege,$privile);
					}
				}
				$data['privileges'] = $arrPrivilege;

				$data['account'] ="";
				$this->load->model('Customermodel');
				if($this->session->userdata('cus_logged_in')){
				   $session_account = $this->session->userdata('cus_logged_in');
				   $data['info'] = $this->Customermodel->GetProfile($session_account['id']);
				}
				$data['wherebuies'] = $this->Homemodel->GetWherebuy();
				$this->load->view('common/header',$hdata);
				$this->load->view('address',$data);
				$this->load->view('common/wherecream');
				$this->load->view('common/footer',$fdata);
			}
		}else{
			redirect('Home');
		}
	}
	public function Confirmation($order_no){
		$hdata['page_title'] = META_TITLE_TH;
		$hdata['meta_desc'] = META_DESC_TH;
		$hdata['meta_keyword'] = META_KEYWORD_TH;
		if ($this->session->userdata('lang')=="TH") {
			$hdata['page_title'] = META_TITLE_TH;
			$hdata['meta_desc'] = META_DESC_TH;
			$hdata['meta_keyword'] = META_KEYWORD_TH;
			$hdata['meta_og_title'] = META_TITLE_TH;
			$hdata['meta_og_desc'] = META_DESC_TH;
		}else{		
			$hdata['page_title'] = META_TITLE_EN;
			$hdata['meta_desc'] = META_DESC_EN;
			$hdata['meta_keyword'] = META_KEYWORD_EN;		
			$hdata['meta_og_title'] = META_TITLE_EN;
			$hdata['meta_og_desc'] = META_DESC_EN;
		}
		$hdata['meta_og_url'] = current_url();		
		$hdata['meta_og_image'] = base_url('assets/image/banner/irin.jpg');

		$hdata['txt_product']=$this->lang->line('txt_product');
		$hdata['txt_article']=$this->lang->line('txt_article');
		$hdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$hdata['txt_promotion']=$this->lang->line('txt_promotion');
		$hdata['txt_review']=$this->lang->line('txt_review');
		$hdata['txt_about']=$this->lang->line('txt_about');
		$hdata['txt_contact']=$this->lang->line('txt_contact');
		$hdata['txt_login']=$this->lang->line('txt_login');
		$hdata['txt_sign']=$this->lang->line('txt_sign');
		$hdata['txt_edit']=$this->lang->line('txt_edit');
		$hdata['txt_change']=$this->lang->line('txt_change');
		$hdata['txt_logout']=$this->lang->line('txt_logout');
		$hdata['txt_policy']=$this->lang->line('txt_policy');
		$hdata['txt_please_mail']=$this->lang->line('txt_please_mail');
		$hdata['txt_and']=$this->lang->line('txt_and');
		$fdata['txt_policy_info']=$this->lang->line('txt_policy_info');
		$hdata['txt_register_success']=$this->lang->line('txt_register_success');
		$hdata['txt_register_desc']=$this->lang->line('txt_register_desc');
		$hdata['txt_confirm']=$this->lang->line('txt_confirm');
		$hdata['txt_confirm_logout']=$this->lang->line('txt_confirm_logout');
		$hdata['txt_ok']=$this->lang->line('txt_ok');
		$hdata['txt_cancle']=$this->lang->line('txt_cancle');
		$hdata['txt_cartemp']=$this->lang->line('txt_cartemp');
		$hdata['txt_forget']=$this->lang->line('txt_forget');
		$hdata['txt_mail']=$this->lang->line('txt_mail');
		$hdata['txt_pass']=$this->lang->line('txt_pass');
		$hdata['txt_keep']=$this->lang->line('txt_keep');
		$hdata['txt_name']=$this->lang->line('txt_name');
		$hdata['txt_conpass']=$this->lang->line('txt_conpass');
		$hdata['txt_conterms']=$this->lang->line('txt_conterms');
		$hdata['txt_terms']=$this->lang->line('txt_terms');
		$fdata['txt_product']=$this->lang->line('txt_product');
		$fdata['txt_info']=$this->lang->line('txt_info');
		$fdata['txt_office']=$this->lang->line('txt_office');
		$fdata['txt_new_product']=$this->lang->line('txt_new_product');
		$fdata['txt_where_to_buy']=$this->lang->line('txt_where_to_buy');
		$fdata['txt_about']=$this->lang->line('txt_about');
		$fdata['txt_contact']=$this->lang->line('txt_contact');
		$fdata['txt_address_footer']=$this->lang->line('txt_address_footer');
		$fdata['txt_terms_info']=$this->lang->line('txt_terms_info');
		$fdata['txt_policy']=$this->lang->line('txt_policy');
		$fdata['txt_help_order']=$this->lang->line('txt_help_order');
		$fdata['txt_help_order_info']=$this->lang->line('txt_help_order_info');
		$fdata['txt_help_payment']=$this->lang->line('txt_help_payment');
		$fdata['txt_help_payment_info']=$this->lang->line('txt_help_payment_info');
		$fdata['txt_help_shipping']=$this->lang->line('txt_help_shipping');
		$fdata['txt_help_shipping_info']=$this->lang->line('txt_help_shipping_info');
		$hdata['txt_mycart']=$this->lang->line('txt_mycart');
		$hdata['txt_item']=$this->lang->line('txt_item');
		$hdata['txt_subtotal']=$this->lang->line('txt_subtotal');
		$hdata['txt_shprate']=$this->lang->line('txt_shprate');
		$hdata['txt_gtotal']=$this->lang->line('txt_gtotal');
		$hdata['txt_contshop']=$this->lang->line('txt_contshop');
		$hdata['txt_checkout']=$this->lang->line('txt_checkout');
		$hdata['txt_viewcart']=$this->lang->line('txt_viewcart');
		$hdata['txt_addtocart_text'] = $this->lang->line('txt_addtocart_text');
		$hdata['txt_line']=$this->lang->line('txt_line');
		$hdata['txt_phone']=$this->lang->line('txt_phone');
		$hdata['txt_his']=$this->lang->line('txt_his');
		$data['txt_item']=$this->lang->line('txt_item');
		$data['txt_price']=$this->lang->line('txt_price');
		$data['text_shippingrate']=$this->lang->line('text_shippingrate');
		$shippingrate = $this->Shippingratemodel->getShippingrateActive();
		$arrShipping = array();
		if($shippingrate){
			foreach($shippingrate as $item){
				if($this->session->userdata('lang')){
					if($this->session->userdata('lang')=="EN"){
						$item['shipping_name_text'] = $item['shipping_name_en'];
					}else{
						$item['shipping_name_text'] = $item['shipping_name'];
					}
				}else{
					$item['shipping_name_text'] = $item['shipping_name'];
				}
				array_push($arrShipping,$item);
			}
		}
		$data['shippings'] = $arrShipping;
		$Order = $this->Ordermodel->GetOrders($order_no);

		if($Order){
			$this->load->library('payment');
			$total = $Order->grand_total;
			$payment = array();
	        $payment['payment_description'] = 'IRIN TRANSECTION '.$order_no;
	        $payment['order_id'] = $Order->id;
	        $payment['invoice_no'] = $Order->order_no;
	        $payment['amount'] = sprintf("%012s", $total*100);
	        $data['payment'] = $this->payment->getHashValue($payment);
	        $data['wherebuies'] = $this->Homemodel->GetWherebuy();
			$this->load->view('common/header',$hdata);
			$this->load->view('payment',$data);
			$this->load->view('common/wherecream');
			$this->load->view('common/footer',$fdata);
		}
	}
	public function addToCart(){
		$product_id=$this->input->post('id');
		$product_qty=$this->input->post('qty');
		$product = $this->Productmodel->GetProductById($product_id);
		$product_name =$product->name_en;
		if($this->session->userdata('lang')){
			if($this->session->userdata('lang')=="EN"){
				$product_name = $product->name_en;
			}else{
				$product_name = $product->name;
			}
		}else{
			$product_name =$product->name;
		}
		
		if($product){
			$newItem = true;
			$carts = $this->cart->contents();
			foreach($carts as $item){
				if($item['id']===$product->id){
					$bag = array('rowid'=>$item['rowid'],'qty'=>$item['qty']+$product_qty);
					$this->cart->update($bag);
					$newItem = false;
				}
			}

			if($newItem){

				$data = array(
		        'id'      => $product->id,
		        'qty'     => $product_qty,
		        'price'   => $product->price ,
		        'name'    => $product_name,
		        'name_en'    => $product_name,
		        'weight'    => $product->weight,
		        'image'    => base_url($product->img),
				);
				$rowid=$this->cart->insert($data);
			}
		}
		$carts = $this->cart->contents();
		
	}
	public function removeCart(){
		$product_id=$this->input->post('id');
		$product_qty=$this->input->post('qty');
		$product = $this->Productmodel->GetProductById($product_id);
		
		if($product){
			$newItem = true;
			$carts = $this->cart->contents();
			foreach($carts as $item){
				if($item['id']===$product->id){
					$bag = array('rowid'=>$item['rowid'],'qty'=>$product_qty);
					$this->cart->update($bag);
					$newItem = false;
				}
			}
		}
		$carts = $this->cart->contents();
		
	}
	public function removeCartItem(){
		$product_id=$this->input->post('id');
		$carts = $this->cart->contents();
		foreach($carts as $item){
			if($item['id']===$product_id){
				$this->cart->remove($item['rowid']);
			}
		}
	}
	public function ClearCart(){
		$this->cart->destroy();
	}
	public function ChackValidateForm(){
		$ar=array(
				array(
					'field'=>'txt_sh_name',
					'label'=>'Shipping first name',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_sh_lastname',
					'label'=>'Shipping lastname',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_sh_email',
					'label'=>'Shipping Email',
					'rules'=>'trim|required|valid_email'
				),
				array(
					'field'=>'txt_sh_address',
					'label'=>'Shipping address',
					'rules'=>'trim|required|min_length[10]'
				),
				array(
					'field'=>'txt_sh_contry',
					'label'=>'Shipping contry',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_sh_province',
					'label'=>'Shipping province',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_sh_city',
					'label'=>'Shipping city',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_sh_subdist',
					'label'=>'Shipping subdistrict',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_sh_pos',
					'label'=>'Shipping zipcode',
					'rules'=>'trim|required|alpha_numeric|min_length[5]'
				),
				array(
					'field'=>'txt_sh_tel',
					'label'=>'Shipping tel',
					'rules'=>'trim|required|min_length[9]|max_length[16]'
				),
				array(
					'field'=>'txt_sh_line',
					'label'=>'Line ID',
					'rules'=>'trim|required'
				),
				array(
					'field'=>'txt_bi_name',
					'label'=>'Billing first name',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_bi_lastname',
					'label'=>'Billing lastname',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_bi_address',
					'label'=>'Billing address',
					'rules'=>'trim|required|min_length[10]'
				),
				array(
					'field'=>'txt_bi_contry',
					'label'=>'Billing contry',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_bi_province',
					'label'=>'Billing province',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_bi_city',
					'label'=>'Billing city',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_bi_subdist',
					'label'=>'Billing subdistrict',
					'rules'=>'trim|required|min_length[2]'
				),
				array(
					'field'=>'txt_bi_pos',
					'label'=>'Billing zipcode',
					'rules'=>'trim|required|min_length[5]'
				),
				array(
					'field'=>'txt_bi_tel',
					'label'=>'Billing tel',
					'rules'=>'trim|required|min_length[9]|max_length[16]'
				)
		);
		$this->form_validation->set_rules($ar);
		
		if ($this->form_validation->run() == FALSE){
			return false;
		}else{
			return true;
		}
	}
}